import datetime
import os
import socket
from collections import deque

from lxml import etree

from generic_module import Module


class OutputClientModule(Module):
    def __init__(self, args):
        expected_params = {"port": 8170, "host": None, "root_path": None, "filter_rules": [("anpr", "not_sibling_of", "wim"), ("lwh", "not_sibling_of", "wim")], "save_data": 1, "max_idle_interval": 10}
        Module.__init__(self, args, expected_params)
        self.parser = etree.XMLParser(remove_blank_text=True)
        # client-thread indice, vehicle deque pairs
        self.vehicles = deque()
        self.s = None
        self.transmitting = False

    def form_message(self, info, typ):
        top_element = etree.Element("i-message", type=typ)
        for key, val in info.items():
            tag = etree.Element(key)
            tag.text = val
            top_element.append(tag)
        return etree.tostring(top_element, pretty_print=False)

    def set_end(self):
        self.end = True

    def save_to_file(self, str_vehicle):
        # these two ports are used by kalmia who coincidentally has the most restrictions regarding xml
        # so saving only "the best" should be the way for now --> for at least as long as we all play by the rules
        if self.port == 8170 or self.port == 50001:
            out_folder = "/ext/"
        else:
            out_folder = "/ext/" + self.name + "/"
        date = datetime.datetime.now().strftime('%Y-%m-%d')
        if not os.path.exists(self.sites_path + "/" + self.sname + out_folder):
            os.makedirs(self.sites_path + "/" + self.sname + out_folder)
        fd = None
        if os.path.exists(self.sites_path + "/" + self.sname + out_folder + date + ".xml"):
            fd = open(self.sites_path + "/" + self.sname + out_folder + date + ".xml", "a+")
        else:
            first_line = '<?xml version="1.0" ?>\n<swd version=' + '"' + "1" + '"><site><name>' + self.sname + '</name><vehicles>'
            fd = open(self.sites_path + "/" + self.sname + out_folder + date + ".xml", "a+")
            fd.write(first_line)
        if fd == None:
            return
        fd.seek(0, os.SEEK_END)
        pos = fd.tell() - 1
        # find the last vehicle closing tag
        while pos > 0 and fd.read(10) != "</vehicle>":
            pos -= 1
            fd.seek(pos, os.SEEK_SET)
            # delete everything from the end of last vehicle closing tag onwards
        if pos > 0:
            fd.seek(pos + 10, os.SEEK_SET)
            fd.truncate()
        fd.write("\n" + str_vehicle)
        last_line = "</vehicles></site></swd>"
        fd.write("\n" + last_line)
        fd.close()

    def add_vehicle(self, vehicle, module_name="irrelevant"):
        # iterate through filtering rules
        for filter_rule in self.filter_rules:
            levels = filter_rule[0].split("/")
            lmnts = vehicle.findall(levels[0])
            # simple ugly way since we're only anticipating two levels
            if len(levels) == 1:
                for lmnt in lmnts:
                    if len(filter_rule) == 3 and filter_rule[1] == "is_sibling_of":
                        if lmnt.getparent().find(filter_rule[2]) != None:
                            lmnt.getparent().remove(lmnt)
                    elif len(filter_rule) == 3 and filter_rule[1] == "not_sibling_of":
                        if lmnt.getparent().find(filter_rule[2]) == None:
                            lmnt.getparent().remove(lmnt)
                    elif len(filter_rule) == 1:
                        lmnt.getparent().remove(lmnt)
            elif len(levels) == 2:
                for lmnt in lmnts:
                    chldlmnts = lmnt.findall(levels[1])
                    for chldlmnt in chldlmnts:
                        if len(filter_rule) == 3 and filter_rule[1] == "is_sibling_of":
                            if chldlmnt.getparent().find(filter_rule[2]) != None:
                                chldlmnt.getparent().remove(chldlmnt)
                        elif len(filter_rule) == 3 and filter_rule[1] == "not_sibling_of":
                            if chldlmnt.getparent().find(filter_rule[2]) == None:
                                chldlmnt.getparent().remove(chldlmnt)
                        elif len(filter_rule) == 1:
                            chldlmnt.getparent().remove(chldlmnt)
        if len(vehicle.getchildren()) == 0:
            return
        if self.save_data == 1:
            self.save_to_file(etree.tostring(vehicle).decode())
        if self.transmitting:
            self.vehicles.append(vehicle)

    def connect_tcp(self):
        self.s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        try:
            self.s.connect((self.host, self.port))
            self.s.settimeout(5)
            return 0
        except socket.error as e:
            self.logger.warning('Connection to {0}:{1} refused ({2})'.format(self.host, self.port, e))
            return 1
        except:
            self.logger.exception('Failed to connect:')
            return 1

    def run(self):
        self.alive = True
        self.end = False
        while True:
            # try-excepts for safety; make sure everything is closed before reopening
            try:
                self.s.shutdown()
            except:
                pass
            try:
                self.s.close()
            except:
                pass
            if self.connect_tcp() == 1:
                self.logger.info('Connection failed.')
                # DON'T exit if connection can't be established
                self.zzzzz(5)
                self.vehicles.clear()
                continue
            self.transmitting = True
            start = datetime.datetime.now()
            while True:
                if (datetime.datetime.now() - start).total_seconds() > self.max_idle_interval:
                    self.transmitting = False
                    break
                if self.end:
                    self.alive = False
                    self.transmitting = False
                    # try-excepts for safety
                    try:
                        self.s.shutdown()
                    except:
                        pass
                    try:
                        self.s.close()
                    except:
                        pass
                    return
                if len(self.vehicles) > 0:
                    try:
                        vehicle = self.vehicles.popleft()
                        complete_xml = '<swd version="1"><site><name>' + self.sname + '</name><vehicles>' + etree.tostring(vehicle).decode() + '</vehicles></site></swd>'
                        to_send = etree.fromstring(complete_xml, self.parser)
                    except:
                        self.logger.exception('Failed form a sendable string from xml:')
                        self.zzzzz(0.5)
                        continue
                    try:
                        self.s.send(etree.tostring(to_send, pretty_print=False))
                        start = datetime.datetime.now()
                    except socket.timeout:
                        self.logger.exception('Connection timed out, restarting connection:')
                        # restart connection
                        self.transmitting = False
                        break
                    except socket.error:
                        self.logger.exception('Socket error, restarting module:')
                        # restarting whole module
                        self.end = True
                self.zzzzz(0.5)
            self.zzzzz(2)
