# -*- coding: utf-8 -*-
"""
Created on Wed Jan 23 12:23:53 2019

@author: Domen
"""
import base64
import datetime
import os
import platform
import socket
import threading
from datetime import date

from lxml import etree
from py_logging.cestel_logging import init_logger

from generic_module import Module


class CommunicationModule(Module):
    def __init__(self, args):
        expected_params = {"port": 8173, "backlog": 5, "recv_buffer_size": 2048, "root_path": None}
        Module.__init__(self, args, expected_params)
        self.parser = etree.XMLParser(remove_blank_text=True)
        self.num_of_clients = 0
        self.clients_lock = threading.Lock()
        self.reset_i = False

        self.acc_logger = init_logger(self.name + "_access_log")

    def are_we_resetting_1(self):
        return self.reset_i

    def set_end(self):
        self.end = True
        # this will initiate shutdown procedure; a bit hacky, but this is how we do thing around here
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.connect(("127.0.0.1", self.port))  # FIXME This may crash with connection refused error
        try:
            s.close()
        except:
            pass

    def form_message(self, info, typ):
        top_element = etree.Element("i-message", type=typ)
        for key, val in info.items():
            tag = etree.Element(key)
            tag.text = val
            top_element.append(tag)
        return etree.tostring(top_element, pretty_print=False)

    def clientthread(self, conn, addr):
        if self.end or self.reset_i:
            return
        with self.clients_lock:
            self.num_of_clients += 1
        try:
            line = ""
            # timeout = 10
            starting_tag_id = -1
            closing_tag_id = -1
            while (starting_tag_id < 0 or closing_tag_id < 0):
                line = line + conn.recv(self.recv_buffer_size).decode()
                starting_tag_id = line.find("<i-message ")
                closing_tag_id = line.find("</i-message>")
                if starting_tag_id >= 0 and closing_tag_id >= 0:
                    break
            if starting_tag_id < 0 or closing_tag_id < 0:
                conn.send(self.form_message({"status": "ERR"}, "comm_response"))
                conn.close()
                with self.clients_lock:
                    self.num_of_clients -= 1
                return
            try:
                original_xml = etree.fromstring(line, self.parser)
            except:
                self.logger.info('Line: {0}.'.format(line))
                conn.send(self.form_message({"status": "ERR"}, "comm_response"))
                conn.close()
                with self.clients_lock:
                    self.num_of_clients -= 1
                return
            if original_xml.attrib["type"] == "i_alive":
                conn.send(self.form_message({"status": "OK"}, "comm_response"))
            elif original_xml.attrib["type"] == "conf_request":
                if os.path.exists("conf/conf.xml"):
                    fd = open("conf/conf.xml", "r")
                    conf_xml = None
                    try:
                        conf_xml = etree.parse(fd)
                        msg = self.form_message({"status": "OK"}, "comm_response")
                        msg_node = etree.fromstring(msg)
                        msg_node.append(conf_xml.getroot())
                        conn.send(etree.tostring(msg_node, pretty_print=False))
                    except:
                        self.logger.exception('Parsing failed:')
                        conn.send(self.form_message({"status": "ERR"}, "comm_response"))
                        # conn.close()
                    fd.close()
                else:
                    self.logger.error('Conf file doesn\'t exist.')
                    conn.send(self.form_message({"status": "ERR"}, "comm_response"))
            elif original_xml.attrib["type"] == "conf":
                curr_ts = datetime.datetime.now().strftime("%Y-%m-%d-%H-%M-%S-%f")
                fd = open("conf/conf.xml", "w")
                fd.write(etree.tostring(original_xml.find("conf"), pretty_print=True).decode())
                fd.close()
                fd = open("conf/conf_" + curr_ts + ".xml", "w")
                fd.write(etree.tostring(original_xml.find("conf"), pretty_print=True).decode())
                fd.close()
                self.acc_logger.info('User with IP ' + addr + " has uploaded a new conf ( " + curr_ts + ").")
                # self.logger.info('reset_i due to type==conf')
                self.reset_i = True
            elif original_xml.attrib["type"] == "i_reset":
                self.reset_i = True
                self.acc_logger.info('User with IP ' + addr + " has sent a reset message.")
                # self.logger.info('reset_i due to type==conf')
            elif original_xml.attrib["type"] == "download_log":
                tdyy = date.today().strftime("%Y-%m-%d")
                tdyy_parts = tdyy.split("-")
                for i in range(1, len(tdyy_parts)):
                    if len(tdyy_parts[i]) < 2:
                        tdyy_parts[i] = "0" + tdyy_parts[i]
                tdyy = "-".join(tdyy_parts)
                try:
                    fd = open("log/" + tdyy + "_" + original_xml.find("module_name").text + ".log", "r")
                    log_txt = fd.read()
                    fd.close()
                    encoded = base64.b64encode(log_txt.encode())
                    conn.send(self.form_message({"status": "OK", "content": encoded}, "comm_response"))
                except:
                    conn.send(self.form_message({"status": "ERR"}, "comm_response"))
            elif original_xml.attrib["type"] == "download_swmstat":
                try:
                    fd = open("log/swmstat.xml")
                    log_txt = fd.read()
                    fd.close()
                    encoded = base64.b64encode(log_txt.encode())
                    conn.send(self.form_message({"status": "OK", "content": encoded}, "comm_response"))
                except:
                    self.logger.exception('Failed to send OK:')
                    conn.send(self.form_message({"status": "ERR"}, "comm_response"))
            elif original_xml.attrib["type"] == "old_events":
                try:
                    frm = original_xml.find("from").text
                    from_day = frm[:10]
                    to = original_xml.find("to").text
                    to_day = to[:10]
                    loc = original_xml.find("location").text
                    loc = self.sites_path + "/" + self.sname + "/" + loc + "/"
                    files = os.listdir(loc)
                    to_send = '<swd version="1"><site><name>' + self.sname + '</name><vehicles>'
                    # + etree.tostring(vehicle).decode() + '</vehicles></site></swd>'
                    for file in files:
                        if not os.path.isfile(loc + file) or not file.endswith(".xml"):
                            continue
                        file_day = file.split(".")[0]
                        if file_day >= from_day and file_day <= to_day:
                            context = etree.iterparse(loc + file, events=('end', 'start'), encoding='iso-8859-1')
                            for action, elem in context:
                                if elem.tag == "vehicle" and action == "end":
                                    childs = elem.getchildren()
                                    if len(childs) > 0:
                                        try:
                                            ts = childs[0].find("ts").text
                                            if ts >= frm and ts < to:
                                                to_send = to_send + etree.tostring(elem).decode()
                                        except Exception as a:
                                            pass
                                    try:
                                        elem.clear()
                                    except:
                                        pass
                    to_send += '</vehicles></site></swd>'
                    conn.send(to_send.encode())
                except:
                    self.logger.exception('Failed to send old events:')
                    conn.send(self.form_message({"status": "ERR"}, "comm_response"))
            elif original_xml.attrib['type'] == 'reboot':
                if platform.system() == 'Windows':
                    conn.send(self.form_message({'status': 'OK'}, 'comm_response'))
                    os.system('shutdown -t 0 -r -f')  # Restart immediately and force all applications to close. TODO Change to subprocess for Python3
                elif platform.system() == 'Linux':
                    conn.send(self.form_message({'status': 'OK'}, 'comm_response'))
                    os.system('reboot now')
                else:
                    conn.send(self.form_message({'status': 'ERR', 'message': 'Command not supported for {}.'.format(platform.system())}, 'comm_response'))
            conn.close()
        except:
            self.logger.exception('General exception:')
        with self.clients_lock:
            self.num_of_clients -= 1

    def run(self):
        self.alive = True
        self.end = False
        try:
            self.sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            self.sock.bind(('', self.port))
            self.sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
            self.sock.listen(self.backlog)
        except OSError as e:
            self.logger.warning('Failed to connect: {}'.format(e))
            return
        except:
            self.logger.exception('Fatal error:')
            self.zzzzz(2)
            self.alive = False
            return
        try:
            while True:
                conn, addr = self.sock.accept()
                if self.end:
                    while True:
                        with self.clients_lock:
                            if self.num_of_clients == 0:
                                try:
                                    conn.close()
                                except:
                                    pass
                                self.sock.close()
                                self.alive = False
                                self.logger.debug('Thread closed correctly.')
                                return
                        self.zzzzz(0.5)
                threading.Thread(target=self.clientthread, args=(conn, addr[0])).start()
        except:
            self.logger.exception('Fatal error:')
            self.sock.close()
        self.alive = False

        # i_message = original_xml
