import datetime
import os
import socket
import struct
import subprocess
import time
from sys import platform

import requests
from lxml import etree

from generic_module import Module


class AlarmModule(Module):
    def __init__(self, args):
        expected_params = {"poll_rate": 600, "min_u": 11.9, "u_tresh": 12.5, "min_dd": 5000, "interval_start": "00:00", "interval_end": "00:00", "timeouts": {}, "alarm_timeout": 7200, "host": "172.16.0.1", "url": "/v1/notifications",
                           "protocol": "http", "root_path": None, "reset_engine_on_traffic_timeout": 0}
        Module.__init__(self, args, expected_params)
        self.voltage = 0
        self.receive_xml_last_received = dict()

    def logLifeEvents(self, site_name, life_event):
        # if i had more time, i would write a shorter letter
        found_site = False
        # found_life_event = False
        diagnostics_tag = etree.Element("diagnostics")
        if not os.path.exists("log/sys_diagnostics.xml"):
            if not os.path.exists("log/"):
                os.mkdir("log")
        else:
            try:
                diagnostics_tag = etree.parse("log/sys_diagnostics.xml").getroot()
            except:
                pass
            diag_site_tags = diagnostics_tag.findall("site")
            for diag_site_tag in diag_site_tags:
                if diag_site_tag.attrib["name"] == site_name:
                    try:
                        diag_site_tag.find(life_event).text = str(int(diag_site_tag.find(life_event).text) + 1)
                    except:
                        diag_life_event_tag = etree.Element(life_event)
                        diag_life_event_tag.text = "1"
                        diag_site_tag.append(diag_life_event_tag)
                    # found_life_event = True
                    found_site = True
                    break
        if not found_site:
            diag_site_tag = etree.Element("site")
            diag_site_tag.attrib["name"] = site_name
            diag_life_event_tag = etree.Element(life_event)
            diag_life_event_tag.text = "1"
            diag_site_tag.append(diag_life_event_tag)
            diagnostics_tag.append(diag_site_tag)
        fd = open("log/sys_diagnostics.xml", "w")
        fd.write(etree.tostring(diagnostics_tag, pretty_print=True).decode())
        fd.close()

    def set_upstream_info(self, module_name, info_type, info_value):
        if info_type == "siwim_system_voltage":
            self.voltage = float(info_value)

    def add_vehicle(self, vehicle, recv_module_name):
        sub_vehicle = vehicle.getchildren()[0]
        if (len(self.receive_xml_last_received) == 0) or (recv_module_name in self.receive_xml_last_received):
            lane = "a"
            try:
                lane = sub_vehicle.find("lane").text
            except:
                pass
            if lane != "a":
                self.receive_xml_last_received[recv_module_name + ":" + str(lane)][1] = time.time()
            else:
                self.receive_xml_last_received[recv_module_name][1] = time.time()

    def getUniXhostname(self):
        sp = subprocess.Popen(["hostname"], stdout=subprocess.PIPE)
        output = sp.communicate()[0]
        return output.strip()

    def register_alarm(self, module_name, module_type):
        for i in range(9):
            if i == 0:
                self.receive_xml_last_received[module_name] = [module_type, time.time()]
            else:
                self.receive_xml_last_received[module_name + ":" + str(i)] = [module_type, time.time()]

    # def ageCTU(self):
    # fn = 'd:/siwim_mkiii/siwim_e/log/ctu_' + datetime.now().strftime('%Y-%m-%d') + '.txt'
    # if not os.path.exists(fn):
    # return '?'
    # try:
    # f = open(fn,'r')
    # return f.readlines()[-1].split('\t')[1][:4]
    # finally:
    # f.close()
    def set_voltage(self, voltage):
        self.voltage = voltage

    def reset_siwim_e(self):
        self.logger.info('Trying to reset SiWIM-E.')
        try:
            fd = open('packet_of_death.msg_sighup', 'rb')
            sighup_packet = fd.read()
            fd.close()
        except:
            self.logger.exception('Failed to reset SiWIM-E: ')
            return
        try:
            e_sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            e_sock.connect(('127.0.0.1', 9020))
            e_sock.sendall(struct.pack('!L', len(sighup_packet) + 4))
            e_sock.sendall(sighup_packet)
            self.logger.info('Shutdown command successfully sent to SiWIM-E.')
        except:
            self.logger.exception('Unable to send sighup: ')
        finally:
            try:
                e_sock.shutdown()
            except:
                pass

    def alarm(self, code, msg, params):
        self.logger.info('Firing an alarm, message: ' + msg)
        payload = None
        comp_name = ""
        if platform == "win32":
            comp_name = os.getenv('COMPUTERNAME').lower()
        elif platform == "linux" or platform == "linux2":
            comp_name = self.getUniXhostname().lower()
        if len(params) == 0:
            payload = {'sys': comp_name, 'type': code, 'msg': msg}
        if len(params) == 1:
            payload = {'sys': comp_name, 'type': code, 'msg': msg, 'par1': params[0]}
        if len(params) == 2:
            payload = {'sys': comp_name, 'type': code, 'msg': msg, 'par1': params[0], 'par2': params[1]}
        if len(params) > 2:
            payload = {'sys': comp_name, 'type': code, 'msg': msg, 'par1': params[0], 'par2': params[1], 'par3': params[2]}
        try:
            resp = requests.post('{0}://{1}{2}'.format(self.protocol, self.host, self.url), payload, timeout=10, verify=False)
            self.logger.info('Response: {0}'.format(resp.text))
        except Exception as e:  # Should be ConnectionRefused, but Python2 doesn't have it.
            self.logger.info('No connection could be made, because {0}://{1} refused it (path {2}):\n{}'.format(self.protocol, self.host, self.url, e))

    def run(self):
        self.logger.debug('Alarm module started.')
        self.alive = True
        self.end = False
        traffic_sent = {}
        traffic_sent_at = {}
        voltage_sent = False
        space_sent = False
        in_start = self.interval_start.split(":")
        in_end = self.interval_end.split(":")
        while True:
            if self.end:
                self.alive = False
                self.logger.debug('Thread closed correctly.')
                return
            try:
                params1 = list()
                params2 = list()
                try:
                    to_send_type1 = ""
                    to_send_type2 = ""
                    sep1 = ""
                    sep2 = ""
                    self.logger.debug(self.receive_xml_last_received)
                    # print self.receive_xml_last_received
                    for name, t in self.receive_xml_last_received.items():
                        # check if name is in traffic_sent_at dict, and decide whether to arm the alarm
                        if name in traffic_sent_at and (time.time() - traffic_sent_at[name] > self.alarm_timeout):
                            traffic_sent[name] = False
                        # if alarm isn't armed (true), disregard
                        # print traffic_sent
                        if name in traffic_sent and traffic_sent[name]:
                            continue
                        # find lane info, 0 for default
                        idx = "0"
                        if ":" in name:
                            parts = name.split(":")
                            idx = parts[1]
                        # if the index isn't listed in the conf file, disregard this iteration
                        if idx not in self.timeouts:
                            continue
                            # decide whether to use timeout or implicit timeout, based on current time
                        tmt = float(self.timeouts[idx][1])
                        if (datetime.datetime.now().hour > int(in_start[0]) or (datetime.datetime.now().hour == int(in_start[0]) and datetime.datetime.now().minute >= int(in_start[1]))) and (
                            datetime.datetime.now().hour < int(in_end[0]) or (datetime.datetime.now().hour == int(in_end[0]) and datetime.datetime.now().minute <= int(in_end[1]))):
                            tmt = float(self.timeouts[idx][0])
                        # check if the alarm should be triggered; start building the alarm
                        if time.time() - t[1] > tmt:
                            try:
                                if idx != "0":
                                    if sep1 == "":
                                        params1.append(parts[0])
                                        params1.append(idx)
                                        params1.append(str(time.time() - t[1]))
                                    else:
                                        params1[0] = params1[0] + sep1 + parts[0]
                                        params1[1] = params1[1] + sep1 + idx
                                        params1[2] = params1[2] + sep1 + str(time.time() - t[1])
                                    to_send_type1 = to_send_type1 + sep1 + '*no ' + t[0] + ":" + parts[0] + ' data* on lane ' + idx + ' for the last ' + str(time.time() - t[1]) + ' seconds'
                                    sep1 = ","
                                else:
                                    if sep2 == "":
                                        params2.append(name)
                                        params2.append(str(time.time() - t[1]))
                                    else:
                                        params2[0] = params2[0] + sep2 + name
                                        params2[1] = params2[1] + sep2 + str(time.time() - t[1])
                                    to_send_type2 = to_send_type2 + sep2 + '*no ' + t[0] + ":" + name + ' data* for the last ' + str(time.time() - t[1]) + ' seconds'
                                    sep2 = ","
                                traffic_sent[name] = True
                                traffic_sent_at[name] = time.time()
                            except:
                                self.logger.exception('Failed something:')
                    # if alarm string isn't empty, send the alarm
                    if to_send_type1 != "":
                        # here, also trigger SiWIM-E reset
                        if "cestel" in to_send_type1:
                            if self.reset_engine_on_traffic_timeout == 1 or self.reset_engine_on_traffic_timeout == 2:
                                self.reset_siwim_e()
                            if self.reset_engine_on_traffic_timeout == 0 or self.reset_engine_on_traffic_timeout == 1:
                                self.alarm(4, to_send_type1, params1)
                    if to_send_type2 != "":
                        self.alarm(5, to_send_type2, params2)
                except:
                    self.logger.exception('General error:')

                params = list()
                try:
                    u = float(self.voltage)
                    # print self.min_u
                    if u > 0 and self.min_u > u:
                        if not voltage_sent:
                            voltage_sent = True
                            try:
                                params.append(str(self.min_u))
                                self.alarm(2, 'Voltage below ' + str(self.min_u) + ' V.', params)
                            except:
                                self.logger.exception('Alarm triggering failed:')
                    elif u > self.u_tresh:
                        voltage_sent = False
                except:
                    self.logger.exception('Voltage error:')

                params = list()
                try:
                    if platform == "win32":
                        dd = self.get_free_mb('d:')
                    else:
                        dd = self.get_free_mb(self.root_path)
                    if self.min_dd > dd:
                        if not space_sent:
                            space_sent = True
                            try:
                                params.append(str(self.min_dd))
                                self.alarm(3, 'D disk space below ' + str(self.min_dd) + ' MB.', params)
                            except:
                                self.logger.exception('Space error:')
                    else:
                        space_sent = False
                except:
                    pass

                self.zzzzz(self.poll_rate)
            except:
                self.logger.exception('Critical error:')
                self.alive = False
