# Because threaded communication with COM ports seems buggy this script is meant to be run as a subprocess
import sys

try:  # First try to obtain information using pywin32 ...
    import win32com.client

    wmi = win32com.client.GetObject("winmgmts:")
    for usb in wmi.InstancesOf("Win32_USBHub"):
        if usb.description == 'USB Mass Storage Device':
            sys.stdout.write(usb.DeviceID)
except:  # If that fails ...
    import ctypes
    from ctypes import Structure, Union, c_ubyte, c_long, c_ulong, c_ushort, c_wchar, c_void_p, c_uint
    from ctypes import byref, POINTER, sizeof, create_unicode_buffer
    from ctypes.wintypes import ULONG, BOOLEAN, BYTE, WORD, DWORD, HANDLE, BOOL, WCHAR, LPWSTR, LPCWSTR
    import platform

    # set up requirements
    INVALID_HANDLE_VALUE = HANDLE(-1)

    if platform.architecture()[0].startswith('64'):
        WIN_PACK = 8
    else:
        WIN_PACK = 1


    class GUID(Structure):
        _pack_ = 1
        _fields_ = [("data1", DWORD),
                    ("data2", WORD),
                    ("data3", WORD),
                    ("data4", BYTE * 8)]


    class DIGCF:
        DEFAULT = 0x00000001
        PRESENT = 0x00000002
        ALLCLASSES = 0x00000004
        PROFILE = 0x00000008
        DEVICEINTERFACE = 0x00000010


    class SP_DEVINFO_DATA(Structure):
        _pack_ = WIN_PACK
        _fields_ = [ \
            ("cb_size", DWORD),
            ("class_guid", GUID),
            ("dev_inst", DWORD),
            ("reserved", POINTER(ULONG)),
        ]


    setup_api = ctypes.windll.setupapi

    SetupDiGetClassDevs = setup_api.SetupDiGetClassDevsW
    SetupDiGetClassDevs.restype = HANDLE
    SetupDiGetClassDevs.argtypes = [
        POINTER(GUID),  # __in_opt  const GUID *ClassGuid,
        LPCWSTR,  # __in_opt  PCTSTR Enumerator,
        HANDLE,  # __in_opt  HWND hwndParent,
        DWORD,  # __in      DWORD Flags
    ]

    SetupDiGetDeviceInstanceId = setup_api.SetupDiGetDeviceInstanceIdW
    SetupDiGetDeviceInstanceId.restype = BOOL
    SetupDiGetDeviceInstanceId.argtypes = [
        HANDLE,  # __in       HDEVINFO DeviceInfoSet,
        POINTER(SP_DEVINFO_DATA),  # __in PSP_DEVINFO_DATA DeviceInfoData,
        LPWSTR,  # __out_opt  PTSTR DeviceInstanceId,
        DWORD,  # __in       DWORD DeviceInstanceIdSize,
        POINTER(DWORD),  # __out_opt  PDWORD RequiredSize
    ]

    SetupDiEnumDeviceInfo = setup_api.SetupDiEnumDeviceInfo
    SetupDiEnumDeviceInfo.restype = BOOL
    SetupDiEnumDeviceInfo.argtypes = [
        HANDLE,  # _In_ HDEVINFO DeviceInfoSet,
        DWORD,  # _In_ DWORD MemberIndex,
        POINTER(SP_DEVINFO_DATA),  # __in PSP_DEVINFO_DATA DeviceInfoData,
    ]

    SetupDiDestroyDeviceInfoList = setup_api.SetupDiDestroyDeviceInfoList
    SetupDiDestroyDeviceInfoList.restype = BOOL
    SetupDiDestroyDeviceInfoList.argtypes = [
        HANDLE,  # __in       HDEVINFO DeviceInfoSet,
    ]

    # Obtain the device instance ID of the USB
    usb_storage = SetupDiGetClassDevs(None, 'USBSTOR', None, DIGCF.PRESENT | DIGCF.ALLCLASSES)
    DeviceInfoData = SP_DEVINFO_DATA()
    DeviceInfoData.cb_size = sizeof(SP_DEVINFO_DATA)
    DeviceIndex = 0

    while SetupDiEnumDeviceInfo(usb_storage, DWORD(DeviceIndex), byref(DeviceInfoData)):
        DeviceInstanceId = create_unicode_buffer(128)
        DeviceInstanceIdSize = DWORD(128)
        RequiredSize = DWORD(0)
        SetupDiGetDeviceInstanceId(usb_storage, byref(DeviceInfoData), DeviceInstanceId, DeviceInstanceIdSize, byref(RequiredSize))

        usb_id = DeviceInstanceId.value.rsplit('&', 1)[0]  # Store the USB ID minus appendage after &, so that we can cross reference it with all device IDs to obtain PID and VID
        DeviceIndex += 1

    SetupDiDestroyDeviceInfoList(usb_storage)

    # Go through all of the USB devices to find the correct PID and VID
    usb_devices = SetupDiGetClassDevs(None, 'USB', None, DIGCF.PRESENT | DIGCF.ALLCLASSES)
    DeviceInfoData = SP_DEVINFO_DATA()
    DeviceInfoData.cb_size = sizeof(SP_DEVINFO_DATA)
    DeviceIndex = 0

    while SetupDiEnumDeviceInfo(usb_devices, DWORD(DeviceIndex), byref(DeviceInfoData)):
        DeviceInstanceId = create_unicode_buffer(128)
        DeviceInstanceIdSize = DWORD(128)
        RequiredSize = DWORD(0)
        SetupDiGetDeviceInstanceId(usb_devices, byref(DeviceInfoData), DeviceInstanceId, DeviceInstanceIdSize, byref(RequiredSize))
        if usb_id.rsplit('\\', 1)[1] == DeviceInstanceId.value.rsplit('\\', 1)[1]:
            sys.stdout.write(DeviceInstanceId.value)
            break
        DeviceIndex += 1

    SetupDiDestroyDeviceInfoList(usb_devices)
