import datetime
import socket

from future.moves.urllib.error import URLError
from future.moves.urllib.request import urlopen
from lxml import etree

from consts import MOD_PAP, PAPAGO_DEVICE_IP, PAPAGO_INTERVAL, PAPAGO_IP, PAPAGO_LISTENERS, PAPAGO_PORT, PAPAGO_START, SAVE_HEADER, SAVE_PATH, SAVE_SUFFIX
from exceptions import StopModule
from generic_module import Module
from helpers.helpers import dict2confstr


class PapagoModule(Module):
    def __init__(self, args):
        Module.__init__(self, args, mandatory_keys=(PAPAGO_IP, PAPAGO_PORT, PAPAGO_START, PAPAGO_LISTENERS, PAPAGO_INTERVAL, PAPAGO_DEVICE_IP))
        self.type = MOD_PAP
        self.protocol = "http://"
        self.loc = "/fresh.xml"

    def get_data(self):
        data_url = self.protocol + self.device_ip + self.loc
        list_of_temps = []
        try:
            request = urlopen(data_url)
        except URLError as e:
            self.logger.warning(f'get_data() failed: {e}.')
            return list_of_temps
        except:
            self.logger.exception('get_data error:')
            return list_of_temps
        try:
            xml = request.read().decode()
            xmlns = xml[xml.find("<?"):xml.find("?>") + 2]
            xml = xml.replace(xmlns, "")
            temp_data = etree.fromstring(xml)
            our_ts = datetime.datetime.now().strftime('%Y-%m-%d-%H-%M-%S')
            sns = temp_data.getchildren()
            curr_idx = self.indexing_start
            for sn in sns:
                # try-except will filter all non-sns elements
                # couldn't use findall("sns") for whatever reason
                try:
                    temp_dict = {}
                    value = float(sn.attrib["val"])
                    status = sn.attrib["status"]
                    ut = int(sn.attrib["unit"])
                    if status != "0":
                        self.logger.info(f'Status: {status}. Consult documentation.')
                    if ut == 1:
                        value = (value - 32.0) * (5 / 9)
                    if ut == 2:
                        value = value - 273
                    temp_dict["T" + str(curr_idx) + "__C"] = format(value, ".2f")
                    temp_dict["ts"] = our_ts
                    list_of_temps.append(temp_dict)
                    curr_idx += 1
                except:
                    continue
        except:
            self.logger.exception("Exception while fetching Papago data:")
        return list_of_temps

    def send_data(self, data):
        conf_str_data = dict2confstr('mydevice', data)
        sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        try:
            sock.sendto(conf_str_data.encode(), (self.udp_ip, self.udp_port))
        finally:
            sock.close()

    def run(self):
        self.alive = True
        self.end = False
        try:
            while True:
                self.throttle()
                if self.end:
                    self.alive = False
                    raise StopModule('Thread closed correctly.')
                # should this really be optional? it's literally everything this module does
                if "t" in self.relevant_for_listeners.lower():
                    datas = self.get_data()
                    # Generate file header.
                    header = f'ts\tT{self.indexing_start}__C'
                    for i in range(self.indexing_start + 1, self.indexing_start + len(datas)):
                        header += f'\tT{i}__C'
                    # Obtain temperatures.
                    temps = []
                    for data in datas:
                        self.send_data(data)
                        for key in data.keys():
                            if key != "ts":
                                temps.append(data[key])
                    self.write_data({SAVE_PATH: 'temperature', SAVE_HEADER: header, SAVE_SUFFIX: 'tsv'}, temps)
                    self.set_upstream_info(self.get_name(), 'temperature_path', self.data_dirs['temperature'])
                self.zzzzz(self.interval)
        except StopModule as e:
            self.log_stop_module(e)
        except:
            self.logger.exception('Fatal error:')
