import datetime
import os
import socket

from future.moves.urllib.error import URLError
from future.moves.urllib.request import urlopen
from lxml import etree

from generic_module import Module


class PapagoModule(Module):
    def __init__(self, args):
        expected_params = {"udp_ip": None, "udp_port": None, "interval": None, "device_ip": None, "indexing_start": None, "root_path": None, "relevant_for_listeners": "t"}
        Module.__init__(self, args, expected_params)
        self.protocol = "http://"
        self.loc = "/fresh.xml"

    def generate_path(self, mod):
        pth = self.sites_path
        pth = pth + "/" + self.sname + "/ext"
        if not os.path.exists(pth):
            os.mkdir(pth)
        pth = pth + "/" + mod
        if not os.path.exists(pth):
            os.mkdir(pth)
        pth = pth + "/papago"
        if not os.path.exists(pth):
            os.mkdir(pth)
        pth = pth + "/" + self.name
        if not os.path.exists(pth):
            os.mkdir(pth)
        return pth

    def get_data(self):
        data_url = self.protocol + self.device_ip + self.loc
        list_of_temps = list()
        try:
            request = urlopen(data_url)
        except URLError as e:
            self.logger.warning('get_data() failed: {0}.'.format(e))
            return list_of_temps
        except:
            self.logger.exception('get_data error:')
            return list_of_temps
        try:
            xml = request.read().decode()
            xmlns = xml[xml.find("<?"):xml.find("?>") + 2]
            xml = xml.replace(xmlns, "")
            temp_data = etree.fromstring(xml)
            our_ts = datetime.datetime.now().strftime('%Y-%m-%d-%H-%M-%S')
            sns = temp_data.getchildren()
            curr_idx = self.indexing_start
            for sn in sns:
                # try-except will filter all non-sns elements
                # couldn't use findall("sns") for whatever reason
                try:
                    temp_dict = dict()
                    value = float(sn.attrib["val"])
                    status = sn.attrib["status"]
                    ut = int(sn.attrib["unit"])
                    if status != "0":
                        self.logger.info('Status: {0}. Consult documentation.'.format(status))
                    if ut == 1:
                        value = (value - 32.0) * (5 / 9)
                    if ut == 2:
                        value = value - 273
                    temp_dict["T" + str(curr_idx) + "__C"] = format(value, ".2f")
                    temp_dict["ts"] = our_ts
                    list_of_temps.append(temp_dict)
                    curr_idx += 1
                except:
                    continue
        except:
            self.logger.exception("Exception while fetching Papago data:")
        return list_of_temps

    def dict2confstr(self, section, d):
        r = '[' + section + ']' + '\n'
        for k, v in d.items():
            r += k + '=' + v + '\n'
        return r

    def send_data(self, data):
        conf_str_data = self.dict2confstr("mydevice", data)
        sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        try:
            sock.sendto(conf_str_data.encode(), (self.udp_ip, self.udp_port))
        finally:
            sock.close()

    def run(self):
        self.alive = True
        self.end = False
        while True:
            if self.end:
                self.alive = False
                self.logger.debug('Thread closed correctly.')
                return
            # should this really be optional? it's literally everything this module does
            if "t" in self.relevant_for_listeners.lower():
                datas = self.get_data()
                pth = self.generate_path("temperature")
                for key, mod in self.downstream_modules_dict.items():
                    mod.set_upstream_info(self.get_name(), "temperature_path", pth)
                date = datetime.datetime.now().strftime('%Y-%m-%d')
                fd = open(pth + "/" + date + ".csv", "a+")
                # create header and write it down once per day
                header = "T" + str(self.indexing_start) + "__C"
                for i in range(self.indexing_start + 1, self.indexing_start + len(datas)):
                    header = header + "\t" + "T" + str(i) + "__C"
                header = "ts\t" + header
                if not os.path.exists(pth + "/" + date + ".csv") or os.path.getsize(pth + "/" + date + ".csv") == 0:
                    fd.write(header + "\n")
                # write to file
                tm = datetime.datetime.now().strftime('%Y-%m-%d-%H-%M-%S')
                to_write = tm
                for data in datas:
                    self.send_data(data)
                    for key in data.keys():
                        if key != "ts":
                            to_write = to_write + "\t" + data[key]
                fd.write(to_write + "\n")
                fd.close()
            self.zzzzz(self.interval)
