#!/usr/bin/python3
import logging
import os
import platform
import shutil
import subprocess
import sys
import time

# TODO Have to reliably import to use it here ...
# logger = init_logger('updater', fmt='%(name)-9s %(asctime)s %(levelname)-8s %(message)s', to_console=True, log_to='siwim_i')
console = logging.StreamHandler()
console.setLevel(logging.DEBUG)
console.setFormatter(logging.Formatter(fmt='%(name)-9s %(asctime)s %(levelname)-8s %(message)s', datefmt='%Y-%m-%d %H:%M:%S'))
logging.getLogger('i_updater').addHandler(console)

logger = logging.getLogger('i_updater')
handler = logging.FileHandler('log/{0}_siwim_i.log'.format(time.strftime('%Y-%m-%d')))
handler.setFormatter(logging.Formatter(fmt='%(name)-9s %(asctime)s %(levelname)-8s [%(filename)s: %(lineno)d] %(message)s', datefmt='%H:%M:%S'))
logger.addHandler(handler)
logger.setLevel(logging.INFO)

siwim_i_expected = [".version", ".venv", "conf", "update", "log", "aggregation_module.py", "alarm_module.py", 'consts.py', "papago_module.py", "camera_module.py", "can_module.py", "communication_module.py", "ctu_module.py", "generic_module.py",
                    "get_usb_info.py", "hist_module.py", "output_module.py", "output_client_module.py", "picture_module.py", "receive_module.py", "siwim_i.py", "status_module.py", "packet_of_death.msg_sighup", "requirements-2.txt",
                    "requirements-3.txt", "changelog.txt",
                    "efoy_module.py"]

try:
    if platform.system() == "Windows":
        from ctypes.wintypes import DWORD
        from ctypes import sizeof, byref, windll

        n = 0


        def EnumProcesses():
            ProcessIds = (DWORD * 256)()
            cb = sizeof(ProcessIds)
            BytesReturned = DWORD()
            # PROCESS_QUERY_INFORMATION = 0x0400
            windll.psapi.EnumProcesses(byref(ProcessIds), cb, byref(BytesReturned))
            nReturned = BytesReturned.value / sizeof(DWORD)
            pidProcess = [i for i in ProcessIds][:int(nReturned)]
            return pidProcess


        def pid_exists(pid):
            return pid in EnumProcesses()


        while n < 30:
            try:
                if not pid_exists(int(sys.argv[1])):
                    # clear clutter
                    old_files = os.listdir(".")
                    try:
                        for old_file in old_files:
                            if old_file not in siwim_i_expected:
                                if os.path.isfile(old_file):
                                    os.remove(old_file)
                                elif os.path.isdir(old_file):
                                    shutil.rmtree(old_file)
                    except Exception as ex:
                        # don't sweat it
                        pass
                    update_files = os.listdir("update")
                    for update_file in update_files:
                        if update_file == "conf.xml":
                            shutil.copyfile("update/conf.xml", "conf/conf.xml")
                        else:
                            if update_file != "i_updater.py":
                                shutil.copyfile("update/" + update_file, update_file)
                        if update_file != "i_updater.py":
                            os.remove("update/" + update_file)
                    time.sleep(10)
                    logger.info('Restarting siwim_i.py ...')
                    if len(update_files) > 1:  # If there's something to update, restart I with the update parameter and check for missing libraries.
                        # if sys.version_info[0] == 2:  # If Python version is 2, we need to set IOEncoding otherwise pip will fail
                        # subprocess.Popen('set PYTHONIOENCODING=utf8 && {} siwim_i.py --update'.format(sys.executable), close_fds=True, shell=True)
                        # moved this to siwim_i.py
                        # else:
                        subprocess.Popen([sys.executable, 'siwim_i.py', '--update'], close_fds=True)
                    else:
                        subprocess.Popen([sys.executable, 'siwim_i.py'], close_fds=True)
                    break
                else:
                    time.sleep(5)
            except Exception as ex:
                logger.exception("Error in inner loop:")
                break
            n += 1
    elif platform.system() == 'Linux':
        update_files = os.listdir("update")
        for update_file in update_files:
            if update_file == "conf.xml":
                shutil.copyfile("update/conf.xml", "conf/conf.xml")
            else:
                if update_file != "i_updater.py":
                    shutil.copyfile("update/" + update_file, update_file)
            if update_file != "i_updater.py":
                os.remove("update/" + update_file)
        logger.info('Restarting siwim_i.py ...')
        subprocess.Popen([sys.executable, 'siwim_i.py'], close_fds=True)
except Exception:
    logger.exception("Update failed:")
