#!/usr/bin/python3
#version = 1.0.0.0

import socket, sys, configparser


def get_info(type):
    '''
    Requests info by type from a port_listener.py
    '''
    conf_file = configparser.ConfigParser()
    conf_file.read("D:\zabbix_scripts\conf.ini")
    port = int(conf_file['communication_ports']['info_sender'])

    lstn_soc = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        lstn_soc.connect(('127.0.0.1', port))
        lstn_soc.send(type.encode())
        data = lstn_soc.recv(1024).decode()
    except:
        data = "Unable to communicate with port_listener.py"
    return data

if __name__ == "__main__":

    info_type = str(sys.argv[1])
    print(get_info(info_type))