import collections
import itertools
import re
import configparser
import sys
from lxml import etree
import copy
import common_functions
import os

# version = "3.5"
# cf_version = "old"
# try:
#   cf_version = common_functions.getver()
# except:
#   pass

classes_path = sys.argv[2]
classes_path = classes_path.replace("\\", "/")
conf = configparser.ConfigParser()
conf.read(classes_path)

xml_path = sys.argv[1]
xml_path = xml_path.replace("\\", "/")
# fd = open(xml_path, "r")
# meas_xml = etree.parse(fd)
# fd.close()

config = configparser.ConfigParser()
script_dir = os.path.dirname(os.path.abspath(__file__))
config_file_path = os.path.join(script_dir, 'swe.conf')
config.read(config_file_path)

# Parameters
group_max_distance = float(config['PARAMS']['group_max_distance'])
group_max_distance_low = float(config['PARAMS']['group_max_distance_low'])
bk = config['PARAMS']['bk']
ax_grp_tolerance = float(config['PARAMS']['ax_grp_tolerance'])
weight_tolerance = float(config['PARAMS']['weight_tolerance'])
ax_dist_tolerance = float(config['PARAMS']['ax_dist_tolerance'])

vehicles = []

for event, element in etree.iterparse(xml_path, events=('end',), tag='vehicle'):
    # Create a deep copy of the element to store in the list
    vehicle_copy = etree.Element("vehicle")
    vehicle_copy.extend(element)  # Copy child elements into new <vehicle>

    vehicles.append(vehicle_copy)  # Store the copy
    element.clear()  # Free memory by clearing the original element

# heavier_vehicles = copy.deepcopy(vehicles)
# lighter_vehicles = copy.deepcopy(vehicles)

# Sweden dir and lanes
lane_direction_cypher = dict()
for entry in config['LANES']:
    entry_parts = config['LANES'][entry].strip().split(";")
    lane_direction_cypher[entry_parts[0]] = (entry_parts[1], entry_parts[2])

# New classification data
idd = config['MEASUREMENT']['bridge_id']

xml_name = xml_path
if "/" in xml_name:
  xml_name = xml_name[xml_name.rfind("/") + 1:len(xml_name) - 4]
else:
  xml_name = xml_name[:len(xml_name) - 4]

out = ""

new_classification = dict()
for entry in config['NSWD']:
    entry_parts = config['NSWD'][entry].strip().split(";")
    new_classification[entry_parts[0]] = entry_parts[1]
#out = "id;ts;direction;lane;speed;class;category;grps;new grps;esal;esal over;modules;modules over\n"

# for vehicle in heavier_vehicles:
#     gvw = float(vehicle.find("wim").find("gvw").text)
#     vehicle.find("wim").find("gvw").text = str(gvw + weight_tolerance * gvw)
#     weights = vehicle.find("wim").find("acws").findall("w")
#     for weight in weights:
#         w = float(weight.text)
#         weight.text = str(w + w * weight_tolerance)
#
# for vehicle in lighter_vehicles:
#     gvw = float(vehicle.find("wim").find("gvw").text)
#     vehicle.find("wim").find("gvw").text = str(gvw - gvw * weight_tolerance)
#     weights = vehicle.find("wim").find("acws").findall("w")
#     for weight in weights:
#         w = float(weight.text)
#         weight.text = str(w - w * weight_tolerance)

l = len(vehicles)
# n = 0
for v in range(l):

    # if n == 3:
    #     print(etree.tostring(vehicles[v-1], pretty_print=True).decode())
    # n += 1

    wim = vehicles[v].find("wim")
    if wim is not None:
        gvw = float(common_functions.kn_to_t(vehicles[v].find("wim").find("gvw").text))
        gvw_h = gvw * (1 + weight_tolerance)
        gvw_l =gvw * (1 - weight_tolerance)
        ads = vehicles[v].find("wim").find("ads").findall("d")
        ads = [float(a.text) for a in ads]
        acws = vehicles[v].find("wim").find("acws").findall("w")
        acws = [float(acw.text) for acw in acws]

        acws_h = [acw * (1 + weight_tolerance) for acw in acws]
        acws_l = [acw * (1 - weight_tolerance) for acw in acws]

        cls = int(vehicles[v].find("wim").find("cls").text)
        lane = vehicles[v].find("wim").find("lane").text

        axgrp = int(vehicles[v].find("wim").find("axgrps").text)
        te_grp = common_functions.TE_group(ads, group_max_distance_low)
        te_grp = int(''.join(map(str, te_grp)))

        grps_tag10 = common_functions.regroupify(vehicles[v], ax_grp_tolerance, conf, bk, ax_dist_tolerance, ads, acws)
        grps = common_functions.regroupify(vehicles[v], ax_grp_tolerance, conf, bk, 0.0, ads, acws)

        esal = common_functions.esal(vehicles[v], conf, axgrp, grps, acws, gvw)
        esal_tag10 = common_functions.esal(vehicles[v], conf, axgrp, grps_tag10, acws, gvw)
        esal_tag10te10 = common_functions.esal(vehicles[v], conf, te_grp, grps_tag10, acws, gvw)
        esal_te10 = common_functions.esal(vehicles[v], conf, te_grp, grps, acws, gvw)

        measured = esal[0]
        maxx = esal[1]
        diff = esal[2]
        es_ax_list1 = esal[3]
        es_ax_list2 = esal[4]
        esals_by_e_g = esal[5]
        legal = esal[6]

        # Sweden axle type
        # axle_type = list()

        axle_type = [list(x) for x in grps]
        axle_type_tag10 = [list(x) for x in grps_tag10]

        # axle_type_tag10 = list()
        #
        # #
        # # for e in grps:
        # #     axle_type.append(e[2])
        # #     print(e)
        # for e_noTA in grps_tag10:
        #     axle_type_tag10.append(e_noTA[2])

            ### DO SAME FOR AXLE_TYPE ^^


        # OVER AXLE

        if common_functions.is_overloaded_by_axles(grps) is True:
            axle_over = True
        else:
            axle_over = False

        if common_functions.is_overloaded_by_axles(grps_tag10) is True:
            axle_over_tag10 = True
        else:
            axle_over_tag10 = False

        # writing new data to xml
        swe_root = vehicles[v].find("wim")

        try:
            swe_lane = etree.SubElement(swe_root, "swe_lane")
            swe_lane.text = ("{}".format(lane_direction_cypher[lane][1]))

            swe_direction = etree.SubElement(swe_root, "swe_direction")
            swe_direction.text = ("{}".format(lane_direction_cypher[lane][0]))
        except:
            print("Skipping lane" + lane + ".")
            continue

        # grp_se = etree.SubElement(swe_root, "grp_se")
        # grp_se.text = ("{}".format(te_grp))

        # grp_se_low = etree.SubElement(swe_root, "grp_se")
        # grp_se_low.text = ("{}".format(te_grp_low))

        grp_se = etree.SubElement(swe_root, "grp_se")
        grp_se.text = ("{}".format(axgrp))

        grp_se_te10 = etree.SubElement(swe_root, "grp_se_te10")
        grp_se_te10.text = ("{}".format(te_grp))

        ## WRITING INFO TO XML
        # ESAL

        measured_es = etree.SubElement(swe_root, "measured_es")
        measured_es.text = ("{}".format(esal[0]))
        measured_es_tag10 = etree.SubElement(swe_root, "measured_es_tag10")
        measured_es_tag10.text = ("{}".format(esal_tag10[0]))
        measured_es_tag10te10 = etree.SubElement(swe_root, "measured_es_tag10te10")
        measured_es_tag10te10.text = ("{}".format(esal_tag10te10[0]))
        measured_es_te10 = etree.SubElement(swe_root, "measured_es_te10")
        measured_es_te10.text = ("{}".format(esal_te10[0]))

        maxx_es = etree.SubElement(swe_root, "maxx_es")
        maxx_es.text = ("{}".format(esal[1]))
        maxx_es_tag10 = etree.SubElement(swe_root, "maxx_es_tag10")
        maxx_es_tag10.text = ("{}".format(esal_tag10[1]))
        maxx_es_tag10te10 = etree.SubElement(swe_root, "maxx_es_tag10te10")
        maxx_es_tag10te10.text = ("{}".format(esal_tag10te10[1]))
        maxx_es_te10 = etree.SubElement(swe_root, "maxx_es_te10")
        maxx_es_te10.text = ("{}".format(esal_te10[1]))

        diff_es = etree.SubElement(swe_root, "diff_es")
        diff_es.text = ("{}".format(esal[2]))
        diff_es_tag10 = etree.SubElement(swe_root, "diff_es_tag10")
        diff_es_tag10.text = ("{}".format(esal_tag10[2]))
        diff_es_tag10te10 = etree.SubElement(swe_root, "diff_es_tag10te10")
        diff_es_tag10te10.text = ("{}".format(esal_tag10te10[2]))
        diff_es_te10 = etree.SubElement(swe_root, "diff_es_te10")
        diff_es_te10.text = ("{}".format(esal_te10[2]))

        es_ax_list1 = etree.SubElement(swe_root, "es_ax_list1")
        es_ax_list1.text = ("{}".format(list(esal[3])))
        es_ax_list1_tag10te10 = etree.SubElement(swe_root, "es_ax_list1_tag10te10")
        es_ax_list1_tag10te10.text = (("{}".format(list(esal_tag10te10[3]))))
        es_ax_list1_te10 = etree.SubElement(swe_root, "es_ax_list1_te10")
        es_ax_list1_te10.text = (("{}".format(list(esal_te10[3]))))
        es_ax_list1_tag10 = etree.SubElement(swe_root, "es_ax_list1_tag10")
        es_ax_list1_tag10.text = (("{}".format(list(esal_tag10[3]))))
        es_ax_list2 = etree.SubElement(swe_root, "es_ax_list2")
        es_ax_list2.text = ("{}".format(esal[4]))
        es_ax_list2_tag10te10 = etree.SubElement(swe_root, "es_ax_list2_tag10te10")
        es_ax_list2_tag10te10.text = (("{}".format(list(esal_tag10te10[4]))))
        es_ax_list2_te10 = etree.SubElement(swe_root, "es_ax_list2_te10")
        es_ax_list2_te10.text = (("{}".format(list(esal_te10[4]))))
        es_ax_list2_tag10 = etree.SubElement(swe_root, "es_ax_list2_tag10")
        es_ax_list2_tag10.text = (("{}".format(list(esal_tag10[4]))))

        esals_by_e_g = etree.SubElement(swe_root, "esals_by_e_g")
        esals_by_e_g.text = ("{}".format(esal[5]))
        esals_by_e_g_te10 = etree.SubElement(swe_root, "esals_by_e_g_te10")
        esals_by_e_g_te10.text = ("{}".format(esal_te10[5]))

        legal_es = etree.SubElement(swe_root, "legal_es")
        legal_es.text = ("{}".format(esal[6]))
        legal_es_tag10 = etree.SubElement(swe_root, "legal_es_tag10")
        legal_es_tag10.text = ("{}".format(esal_tag10[6]))
        legal_es_tag10te10 = etree.SubElement(swe_root, "legal_es_tag10te10")
        legal_es_tag10te10.text = ("{}".format(esal_tag10te10[6]))
        legal_es_te10 = etree.SubElement(swe_root, "legal_es_te10")
        legal_es_te10.text = ("{}".format(esal_te10[6]))

        # GVW OVERs and constrains

        gvw_over, constrains = common_functions.is_gvw_overloaded(vehicles[v], conf, bk, grps, ads, acws, gvw)
        gvw_over_tag10, constrains_tag10 = common_functions.is_gvw_overloaded(vehicles[v], conf, bk, grps_tag10, ads, acws, gvw)
        gvw_over_tag10te10, constrains_tag10te10 = common_functions.is_gvw_overloaded(vehicles[v], conf, bk, grps_tag10, ads, acws, gvw)
        gvw_over_te10, constrains_te10 = common_functions.is_gvw_overloaded(vehicles[v], conf, bk, grps, ads, acws, gvw)


        if len(gvw_over) > 0:
            gvw_over_se = etree.SubElement(swe_root, "gvw_over_se")
            gvw_over_se.text = ("{}".format(gvw_over))

        if len(gvw_over_tag10te10) > 0:
            gvw_over_se_tag10te10 = etree.SubElement(swe_root, "gvw_over_tag10te10")
            gvw_over_se_tag10te10.text = ("{}".format(gvw_over_tag10te10))


        constrains_se = etree.SubElement(swe_root, "constrains")
        constrains_se.text = ("{}".format(constrains))

        constrains_se_tag10 = etree.SubElement(swe_root, "constrains_tag10")
        constrains_se_tag10.text = ("{}".format(constrains_tag10))


        over_by_axle = etree.SubElement(swe_root, "axle_over")
        over_by_axle.text = ("{}".format(axle_over))

        over_by_axle_tag10 = etree.SubElement(swe_root, "axle_over_tag10")
        over_by_axle_tag10.text = ("{}".format(axle_over_tag10))


        axle_types = etree.SubElement(swe_root, "axle_type")
        axle_types.text = ("{}".format(axle_type))

        axle_types_tag10 = etree.SubElement(swe_root, "axle_type_tag10")
        axle_types_tag10.text = ("{}".format(axle_type_tag10))

        ## writing NEWER NSWD
        lane = vehicles[v].find("wim").find("lane").text
        if vehicles[v].find("wim").find("cls").text != "140":
            try:
                new_class = new_classification[vehicles[v].find("wim").find("cls").text]
            except Exception:
                print("No swedish classification for: " + vehicles[v].find("wim").find("cls").text)
                new_class = "ERR"
        else:
            new_class = "140"

        grps_str = ""
        for grp in grps:
            grps_str = grps_str + str(grp[1])
        out = (out + idd + ";" + vehicles[v].find("wim").find("ts").text + ";" + swe_lane.text + ";"
               + swe_direction.text + ";" + common_functions.ms_to_kmh(vehicles[v].find("wim").find("v").text) + ";"
               + common_functions.mod_count(vehicles[v], conf) + ";" + new_class + ";" + vehicles[v].find(
            "wim").find("naxles").text + ";" + grps_str + ";" + common_functions.kn_to_t(
            vehicles[v].find("wim").find("gvw").text) + ";")
        weights = vehicles[v].find("wim").find("acws").findall("w")
        distances = vehicles[v].find("wim").find("ads").findall("d")
        for weight in weights:
            out = out + common_functions.kn_to_t(weight.text) + ";"

        tmp_out = ""
        distance_sum = 0
        for distance in distances:
            distance_sum += round(float(distance.text), 5)
            tmp_out = tmp_out + str(round(float(distance.text), 5)) + ";"

        out = out + str(round(float(distance_sum), 5)) + ";"
        out = out + tmp_out

        is_mp = (int(vehicles[v].find("wim").find("flags").text[-1], 16) % 2) == 1
        is_mp_str = ""
        if is_mp:
            is_mp_str = "MP"
        out = out + is_mp_str + "\n"

        ## lighter, heavier, TE10 manipulation
        # lighter
        grps_l_tag10te10 = common_functions.regroupify(vehicles[v], ax_grp_tolerance, conf, bk, ax_dist_tolerance, ads, acws_l)
        grps_l = common_functions.regroupify(vehicles[v], ax_grp_tolerance, conf, bk, 0.0, ads, acws_l)

        if common_functions.is_overloaded_by_axles(grps_l) is True:
            axle_over_l = True
        else:
            axle_over_l = False

        if common_functions.is_overloaded_by_axles(grps_l_tag10te10) is True:
            axle_over_l_tag10te10 = True
        else:
            axle_over_l_tag10te10 = False

        esal_light = common_functions.esal(vehicles[v], conf, axgrp, grps_l, acws_l, gvw_l)
        esal_light_tag10te10 = common_functions.esal(vehicles[v], conf, te_grp, grps_tag10, acws_l, gvw_l)
        esal_light_tag10 = common_functions.esal(vehicles[v], conf, axgrp, grps_tag10, acws_l, gvw_l)
        esal_light_te10 = common_functions.esal(vehicles[v], conf, te_grp, grps, acws_l, gvw_l)

        measured_l = esal_light[0]
        maxx_l = esal_light[1]
        diff_l = esal_light[2]
        es_ax_list1_l = esal_light[3]
        es_ax_list2_l = esal_light[4]
        esals_by_e_g_l = esal_light[5]
        legal_l = esal_light[6]

        measured_es_l = etree.SubElement(swe_root, "measured_es_l")
        measured_es_l.text = ("{}".format(esal_light[0]))
        measured_es_l_tag10te10 = etree.SubElement(swe_root, "measured_es_l_tag10te10")
        measured_es_l_tag10te10.text = ("{}".format(esal_light_tag10te10[0]))
        measured_es_l_tag10 = etree.SubElement(swe_root, "measured_es_l_tag10")
        measured_es_l_tag10.text = ("{}".format(esal_light_tag10[0]))
        measured_es_l_te10 = etree.SubElement(swe_root, "measured_es_l_te10")
        measured_es_l_te10.text = ("{}".format(esal_light_te10[0]))

        # diff_es_light = etree.SubElement(swe_root, "diff_es_l")
        # diff_es_light.text = ("{}".format(esal_light[2]))
        diff_es_l = etree.SubElement(swe_root, "diff_es_l")
        diff_es_l.text = ("{}".format(esal_light[2]))
        diff_es_l_tag10te10 = etree.SubElement(swe_root, "diff_es_l_tag10te10")
        diff_es_l_tag10te10.text = ("{}".format(esal_light_tag10te10[2]))
        diff_es_l_tag10 = etree.SubElement(swe_root, "diff_es_l_tag10")
        diff_es_l_tag10.text = ("{}".format(esal_light_tag10[2]))
        diff_es_l_te10 = etree.SubElement(swe_root, "diff_es_l_te10")
        diff_es_l_te10.text = ("{}".format(esal_light_te10[2]))

        legal_es_l = etree.SubElement(swe_root, "legal_es_l")
        legal_es_l.text = ("{}".format(esal_light[6]))
        legal_es_l_tag10te10 = etree.SubElement(swe_root, "legal_es_l_tag10te10")
        legal_es_l_tag10te10.text = ("{}".format(esal_light_tag10te10[6]))
        legal_es_l_tag10 = etree.SubElement(swe_root, "legal_es_l_tag10")
        legal_es_l_tag10.text = ("{}".format(esal_light_tag10[6]))
        legal_es_l_te10 = etree.SubElement(swe_root, "legal_es_l_te10")
        legal_es_l_te10.text = ("{}".format(esal_light_te10[6]))

        gvw_over_light, constrains_l = common_functions.is_gvw_overloaded(vehicles[v], conf, bk,
                                                                          grps_l, ads, acws_l, gvw_l)
        gvw_over_tag10te10_light, constrains_tag10_l = common_functions.is_gvw_overloaded(vehicles[v], conf, bk,
                                                                                          grps_l_tag10te10, ads, acws_l, gvw_l)

        if len(gvw_over_light) > 0:
            gvw_over_light_element = etree.SubElement(swe_root, "gvw_over_l_se")
            gvw_over_light_element.text = " ".join(
                map(str, gvw_over_light))  # Convert list elements to a space-separated string

        if len(gvw_over_tag10te10_light) > 0:
            gvw_over_tag10te10_light = etree.SubElement(swe_root, "gvw_over_l_tag10te10")
            gvw_over_tag10te10_light.text = " ".join(
                map(str, gvw_over_tag10te10_light))  # Convert list elements to a space-separated string

        constrains_l_se = etree.SubElement(swe_root, "constrains_l")
        constrains_l_se.text = " ".join(map(str, constrains_l))

        constrains_l_tag10 = etree.SubElement(swe_root, "constrains_l_tag10")
        constrains_l_tag10.text = " ".join(map(str, constrains_tag10_l))
        #
        # print(gvw_over_light)
        # print(constrains_l)
        # print(constrains_tag10_l)

        # constrains_l = etree.SubElement(swe_root, "constrains_l")
        # constrains_l.text = ("{}".format(constrains_l))
        #
        # constrains_l_tag10 = etree.SubElement(swe_root, "constrains_l_tag10")
        # constrains_l_tag10.text = ("{}".format(constrains_tag10_l))

        over_by_axle_l_tag10te10 = etree.SubElement(swe_root, "axle_over_l_tag10te10")
        over_by_axle_l_tag10te10.text = ("{}".format(axle_over_l_tag10te10))
        over_by_axle_l = etree.SubElement(swe_root, "axle_over_l")
        over_by_axle_l.text = ("{}".format(axle_over_l))

    # heavier
        grps_h_tag10te10 = common_functions.regroupify(vehicles[v], ax_grp_tolerance, conf, bk, ax_dist_tolerance, ads, acws_h)
        grps_h = common_functions.regroupify(vehicles[v], ax_grp_tolerance, conf, bk, 0.0, ads, acws_h)

        esal_heavy = common_functions.esal(vehicles[v], conf, axgrp, grps_h, acws_h, gvw_h)
        esal_heavy_tag10te10 = common_functions.esal(vehicles[v], conf, te_grp, grps_tag10, acws_h, gvw_h)
        esal_heavy_tag10 = common_functions.esal(vehicles[v], conf, axgrp, grps_tag10, acws_h, gvw_h)
        esal_heavy_te10 = common_functions.esal(vehicles[v], conf, te_grp, grps, acws_h, gvw_h)

        if common_functions.is_overloaded_by_axles(grps_h) is True:
            axle_over_h = True
        else:
            axle_over_h = False

        if common_functions.is_overloaded_by_axles(grps_h_tag10te10) is True:
            axle_over_h_tag10te10 = True
        else:
            axle_over_h_tag10te10 = False

        measured_h = esal_heavy[0]
        maxx_h = esal_heavy[1]
        diff_h = esal_heavy[2]
        es_ax_list1_h = esal_heavy[3]
        es_ax_list2_h = esal_heavy[4]
        esals_by_e_g_h = esal_heavy[5]
        legal_h = esal_heavy[6]

        measured_es_h = etree.SubElement(swe_root, "measured_es_h")
        measured_es_h.text = ("{}".format(esal_heavy[0]))
        measured_es_h_tag10te10 = etree.SubElement(swe_root, "measured_es_h_tag10te10")
        measured_es_h_tag10te10.text = ("{}".format(esal_heavy_tag10te10[0]))
        measured_es_h_tag10 = etree.SubElement(swe_root, "measured_es_h_tag10")
        measured_es_h_tag10.text = ("{}".format(esal_heavy_tag10[0]))
        measured_es_h_te10 = etree.SubElement(swe_root, "measured_es_h_te10")
        measured_es_h_te10.text = ("{}".format(esal_heavy_te10[0]))

        # diff_es_heavy = etree.SubElement(swe_root, "diff_es_h")
        # diff_es_heavy.text = ("{}".format(esal_heavy[2]))
        diff_es_h = etree.SubElement(swe_root, "diff_es_h")
        diff_es_h.text = ("{}".format(esal_heavy[2]))
        diff_es_h_tag10te10 = etree.SubElement(swe_root, "diff_es_h_tag10te10")
        diff_es_h_tag10te10.text = ("{}".format(esal_heavy_tag10te10[2]))
        diff_es_h_tag10 = etree.SubElement(swe_root, "diff_es_h_tag10")
        diff_es_h_tag10.text = ("{}".format(esal_heavy_tag10[2]))
        diff_es_h_te10 = etree.SubElement(swe_root, "diff_es_h_te10")
        diff_es_h_te10.text = ("{}".format(esal_heavy_te10[2]))

        legal_es_h = etree.SubElement(swe_root, "legal_es_h")
        legal_es_h.text = ("{}".format(esal_heavy[6]))
        legal_es_h_tag10te10 = etree.SubElement(swe_root, "legal_es_h_tag10te10")
        legal_es_h_tag10te10.text = ("{}".format(esal_heavy_tag10te10[6]))
        legal_es_h_tag10 = etree.SubElement(swe_root, "legal_es_h_tag10")
        legal_es_h_tag10.text = ("{}".format(esal_heavy_tag10[6]))
        legal_es_h_te10 = etree.SubElement(swe_root, "legal_es_h_te10")
        legal_es_h_te10.text = ("{}".format(esal_heavy_te10[6]))

        gvw_over_heavy, constrains_h = common_functions.is_gvw_overloaded(vehicles[v], conf, bk,
                                                                                          grps_h, ads, acws_h, gvw_h)
        gvw_over_tag10te10_heavy, constrains_tag10_h = common_functions.is_gvw_overloaded(vehicles[v], conf, bk,
                                                                                          grps_h_tag10te10, ads, acws_h, gvw_h)

        if len(gvw_over_heavy) > 0:
            gvw_over_heavy_element = etree.SubElement(swe_root, "gvw_over_h_se")
            gvw_over_heavy_element.text = " ".join(
                map(str, gvw_over_heavy))  # Convert list elements to a space-separated string

        if len(gvw_over_tag10te10_heavy) > 0:
            gvw_over_tag10te10_heavy = etree.SubElement(swe_root, "gvw_over_h_tag10te10")
            gvw_over_tag10te10_heavy.text = " ".join(
                map(str, gvw_over_tag10te10_heavy))  # Convert list elements to a space-separated string


        constrains_h_se = etree.SubElement(swe_root, "constrains_h")
        constrains_h_se.text = ("{}".format(constrains_h))

        constrains_h_tag10 = etree.SubElement(swe_root, "constrains_h_tag10")
        constrains_h_tag10.text = ("{}".format(constrains_tag10_h))

        over_by_axle_h = etree.SubElement(swe_root, "axle_over_h")
        over_by_axle_h.text = ("{}".format(axle_over_h))

        # over_by_axle_h = etree.SubElement(swe_root, "axle_over_h")
        # over_by_axle_h.text = "true" if axle_over_h else "false"
        #
        # over_by_axle_h_tag10te10 = etree.SubElement(swe_root, "axle_over_h_tag10te10")
        # over_by_axle_h_tag10te10.text = "true" if axle_over_h_tag10te10 else "false"

        over_by_axle_h_tag10te10 = etree.SubElement(swe_root, "axle_over_h_tag10te10")
        over_by_axle_h_tag10te10.text = ("{}".format(axle_over_h_tag10te10))

root = etree.Element("site")

for r in root:
    print(etree.tostring(r, encoding="utf-8").decode("utf-8"))

## write newer_nswd

with open(xml_name + "_newer_nswd.csv", "w") as fd:
    fd.write(out)

## write XML

xml_linearized = list()
parser = etree.XMLParser(remove_blank_text=True)

for v in vehicles:
    v = etree.XML(etree.tostring(v, encoding="utf-8").decode("utf-8"), parser)
    xml_linearized.append(etree.tostring(v, encoding="utf-8").decode("utf-8"))


n = 0
with open("Sweden.xml", "w", encoding="utf-8") as file:
    print("3")
    if n == 0:
        file.write('<?xml version="1.0" ?>\n')
        file.write('<swd version="1">\n')
        file.write('<site>\n')
        file.write(f'<name>{xml_name}</name>\n')
        # file.write(f'<name>{site_name}</name>\n')
        file.write('<vehicles>\n')
    for row in xml_linearized:
        file.write(row)
        file.write("\n")
    file.write('</vehicles>\n')
    file.write('</site>\n')
    file.write('</swd>\n')
