import collections
import datetime
import itertools
import re
import sys
import linecache

version = "4.6"

def getver():
  return version


def PrintException():
    exc_type, exc_obj, tb = sys.exc_info()
    f = tb.tb_frame
    lineno = tb.tb_lineno
    filename = f.f_code.co_filename
    linecache.checkcache(filename)
    line = linecache.getline(filename, lineno, f.f_globals)

    print(('EXCEPTION IN ({}, LINE {} "{}"): {}'.format(filename, lineno, line.strip(), exc_obj)))


# Print iterations progress
def printProgressBar(iteration, total, prefix='', suffix='', decimals=1, length=100, fill='|', printEnd="\r"):
    """
    Call in a loop to create terminal progress bar
    @params:
        iteration   - Required  : current iteration (Int)
        total       - Required  : total iterations (Int)
        prefix      - Optional  : prefix string (Str)
        suffix      - Optional  : suffix string (Str)
        decimals    - Optional  : positive number of decimals in percent complete (Int)
        length      - Optional  : character length of bar (Int)
        fill        - Optional  : bar fill character (Str)
        printEnd    - Optional  : end character (e.g. "\r", "\r\n") (Str)
    """
    percent = ("{0:." + str(decimals) + "f}").format(100 * (iteration / float(total)))
    filledLength = int(length * iteration // total)
    bar = fill * filledLength + '-' * (length - filledLength)
    sys.stdout.write('\r%s |%s| %s%% %s' % (prefix, bar, percent, suffix))
    sys.stdout.flush()
    # Print New Line on Complete
    if iteration == total:
        sys.stdout.write("")

# def process_vehicle(vehicle, weight_tolerance, modifier):
#     """Modify the vehicle with + or - weight tolerance."""
#     wim = vehicle.find("wim")
#     if wim is None:
#         return None  # Skip invalid entries
#
#     gvw_element = wim.find("gvw")
#     if gvw_element is not None and gvw_element.text is not None:
#         gvw = float(gvw_element.text)
#         gvw_element.text = str(gvw * (1 + modifier * weight_tolerance))
#
#     acws = wim.find("acws")
#     if acws is not None:
#         for weight in acws.findall("w"):
#             if weight.text is not None:
#                 w = float(weight.text)
#                 weight.text = str(w * (1 + modifier * weight_tolerance))

    # return vehicle  # Return modified vehicle

def mod_count(vehicle, conf):
  try:
    scls = vehicle.find("wim").find("cls").text
    if scls == "140":
      return ""
    conf_scls = "subclass_" + scls
    axle_configuration = conf.get(conf_scls, "axle_configuration")
    cnt = 0
    for i in range(len(axle_configuration)):
      if axle_configuration[i].isalpha():# and axle_configuration[i].lower() != 's':
        cnt+=1
    return str(cnt)
  except Exception:
    return ""

def kn_to_t(weight):
    return str(round(float(weight) / 9.82, 4))

def ms_to_kmh(speed):
  return str(round(float(speed) * 3.6, 4))

def get_hr(vehicle):
  ts = vehicle.find("wim").find("ts").text
  ts_parts = ts.split("-")
  return int(ts_parts[3])

def get_day(vehicle):
  ts = vehicle.find("wim").find("ts").text
  ts_parts = ts.split("-")
  return ts_parts[0] + "-" + ts_parts[1] + "-" + ts_parts[2]

def get_max(num_of_as):
  if num_of_as < 6:
    maxes = {1:10.0,2:18.0,3:24.0,4:30.0,5:35.0}
    return maxes[num_of_as]
  else:
    return num_of_as * 5 + 11

def esal(vehicle, conf, grps, new_groups, acws, gvw):
    # print new_groups
    individual_grp_esal_sums1 = [0, 0, 0, 0]
    individual_grp_esal_sums2 = [0, 0, 0, 0, 0, 0, 0, 0]

    grps = str(grps)
    esals_by_esal_groups = [0, 0, 0, 0, 0, 0, 0, 0, 0]
    try:
        # maxes = {1:10.0,2:18.0,3:24.0,4:30.0,5:35.0,6:41.0,7:46.0}
        cls = vehicle.find("wim").find("cls").text
        # ax_weights = vehicle.find("wim").find("acws").findall("w")

        # gvw = float(kn_to_t(vehicle.find("wim").find("gvw").text))

        tyre_type_factors = {1: 1.3, 2: 1.0, 3: 1.2}
        if cls != "140":
            conf_scls = "subclass_" + cls
            tyre_type_parts = conf.get(conf_scls, "tyre_type").split(",")
            # tyre_type_factors = {1:1.3, 2:1.0, 3:1.2}

        single_max = list()
        single_legal = list()

        idx = 0
        for new_grp in new_groups:
            for i in range(new_grp[1]):
                single_max.append(float(new_grp[3]) / new_grp[1])
                single_legal.append(min(float(kn_to_t(acws[idx])), float(new_grp[3]) / new_grp[1]))
                # single_legal.append(min(float(kn_to_t(ax_weights[idx].text)), float(new_grp[3]) / new_grp[1]))
                idx += 1

        curr = 0
        esal_sum = 0
        esal_max = 0
        esal_legal = 0
        esal_over = 0

        # sm = 0
        # for w in ax_weights:
        # print float(kn_to_t(w.text))

        # print new_groups

        # print sm

        # tm = list()
        # for new_group in new_groups:
        # tm.append(new_group[5])
        # print sum(tm)

        # print("----")
        # print(type(grps))

        for i in range(len(grps)):
            a = grps[i]
            num_of_as = int(a, 16)
            max_load = 0
            legal_load = 0
            for j in range(num_of_as):
                max_load += single_max.pop(0)
                legal_load += single_legal.pop(0)
            ax_grp_sum = 0
            tyre_type = 2
            for j in range(curr, curr + num_of_as):
                # hacky hacky
                if cls != "140":
                    if int(tyre_type_parts[curr]) != 1 and tyre_type != 1:
                        tyre_type = max(int(tyre_type_parts[curr]), tyre_type)
                    else:
                        tyre_type = 1
                ax_grp_sum += float(kn_to_t(acws[j]))
                # ax_grp_sum += float(kn_to_t(ax_weights[j].text))
                curr += 1
            # if num_of_as > 7:
            # num_of_as = 7

            if cls == "140":
                if gvw <= 8:
                    tyre_type = 1
                else:
                    if i == 0:
                        tyre_type = 1
                    else:
                        tyre_type = 2

            idx1 = num_of_as - 1
            idx2 = idx1
            if idx2 > 7:
                idx2 = 7
            if idx1 > 3:
                idx1 = 3

            tmp_esal = tyre_type_factors[tyre_type] * pow((ax_grp_sum / get_max(num_of_as)), 4)
            # if (legal_load) > ax_grp_sum:
            # print legal_load
            # print ax_grp_sum
            # print str(legal_load) + "|" + str(ax_grp_sum)
            # print single_legal
            # print new_groups
            # print grps
            # for w in ax_weights:
            # print float(kn_to_t(w.text))
            if tmp_esal <= 0.2:
                esals_by_esal_groups[0] += 1
            elif tmp_esal <= 0.4:
                esals_by_esal_groups[1] += 1
            elif tmp_esal <= 0.6:
                esals_by_esal_groups[2] += 1
            elif tmp_esal <= 0.8:
                esals_by_esal_groups[3] += 1
            elif tmp_esal <= 1.0:
                esals_by_esal_groups[4] += 1
            elif tmp_esal <= 1.2:
                esals_by_esal_groups[5] += 1
            elif tmp_esal <= 1.4:
                esals_by_esal_groups[6] += 1
            elif tmp_esal <= 1.6:
                esals_by_esal_groups[7] += 1
            elif tmp_esal > 1.6:
                esals_by_esal_groups[8] += 1

            individual_grp_esal_sums1[idx1] += tmp_esal
            if idx2 < 8:
                individual_grp_esal_sums2[idx2] += tmp_esal

            esal_sum += tmp_esal
            esal_max = esal_max + tyre_type_factors[tyre_type] * pow((max_load / get_max(num_of_as)), 4)
            esal_legal = esal_legal + tyre_type_factors[tyre_type] * pow((legal_load / get_max(num_of_as)), 4)

            esal_dif = tmp_esal - tyre_type_factors[tyre_type] * pow((legal_load / get_max(num_of_as)), 4)
            if esal_dif < 0:
                esal_dif = 0
            esal_over += esal_dif
            # values of interest
        return esal_sum, esal_max, esal_over, individual_grp_esal_sums1, individual_grp_esal_sums2, esals_by_esal_groups, esal_legal
    except Exception as ex:
        # print str(ex)
        return 0, 0, 0, individual_grp_esal_sums1, individual_grp_esal_sums2, esals_by_esal_groups, 0

# def get_gvw_constraint(vehicle, conf, bk, grps):
#   try:
#     #cls = vehicle.find("wim").find("cls").text
#     #conf_scls = "subclass_" + cls
#     #gvw = conf.get(conf_scls, "max_GVW__kN")
#     #gvw = float(kn_to_t(gvw))
#     over_types, constraints = is_gvw_overloaded(vehicle, conf, bk, grps, ads, acws, gvw)
#     return min(constraints)
#   except Exception as ex:
#     print(ex)
#     return 0

def get_constraint_bki(vehicle, indexes, ax_dist_tolerance, ads):
    bk1_constraints = {(0, 1.0 + (len(indexes) * ax_dist_tolerance)): 11.5
        , (1.0 + (len(indexes) * ax_dist_tolerance), 1.3 + (len(indexes) * ax_dist_tolerance)): 16
        , (1.3 + (len(indexes) * ax_dist_tolerance), 1.8 + (len(indexes) * ax_dist_tolerance)): 18
        , (1.8 + (len(indexes) * ax_dist_tolerance), 2.0 + (len(indexes) * ax_dist_tolerance)): 20
        , (2.0 + (len(indexes) * ax_dist_tolerance), 2.6 + (len(indexes) * ax_dist_tolerance)): 21
        , (2.6 + (len(indexes) * ax_dist_tolerance), 4.4 + (len(indexes) * ax_dist_tolerance)): 24
        , (4.4 + (len(indexes) * ax_dist_tolerance), 4.7 + (len(indexes) * ax_dist_tolerance)): 25
        , (4.7 + (len(indexes) * ax_dist_tolerance), 5.2 + (len(indexes) * ax_dist_tolerance)): 26
        , (5.2 + (len(indexes) * ax_dist_tolerance), 5.4 + (len(indexes) * ax_dist_tolerance)): 27
        , (5.4 + (len(indexes) * ax_dist_tolerance), 5.6 + (len(indexes) * ax_dist_tolerance)): 28
        , (5.6 + (len(indexes) * ax_dist_tolerance), 5.8 + (len(indexes) * ax_dist_tolerance)): 29
        , (5.8 + (len(indexes) * ax_dist_tolerance), 6.0 + (len(indexes) * ax_dist_tolerance)): 30
        , (6.0 + (len(indexes) * ax_dist_tolerance), 6.2 + (len(indexes) * ax_dist_tolerance)): 31
        , (6.2 + (len(indexes) * ax_dist_tolerance), 8.25 + (len(indexes) * ax_dist_tolerance)): 32
        , (8.25 + (len(indexes) * ax_dist_tolerance), 8.5 + (len(indexes) * ax_dist_tolerance)): 33
        , (8.5 + (len(indexes) * ax_dist_tolerance), 8.75 + (len(indexes) * ax_dist_tolerance)): 34
        , (8.75 + (len(indexes) * ax_dist_tolerance), 9.0 + (len(indexes) * ax_dist_tolerance)): 35
        , (9.0 + (len(indexes) * ax_dist_tolerance), 9.25 + (len(indexes) * ax_dist_tolerance)): 36
        , (9.25 + (len(indexes) * ax_dist_tolerance), 9.5 + (len(indexes) * ax_dist_tolerance)): 37
        , (9.5 + (len(indexes) * ax_dist_tolerance), 9.75 + (len(indexes) * ax_dist_tolerance)): 38
        , (9.75 + (len(indexes) * ax_dist_tolerance), 10.0 + (len(indexes) * ax_dist_tolerance)): 39
        , (10.0 + (len(indexes) * ax_dist_tolerance), 10.25 + (len(indexes) * ax_dist_tolerance)): 40
        , (10.25 + (len(indexes) * ax_dist_tolerance), 10.5 + (len(indexes) * ax_dist_tolerance)): 41
        , (10.5 + (len(indexes) * ax_dist_tolerance), 10.75 + (len(indexes) * ax_dist_tolerance)): 42
        , (10.75 + (len(indexes) * ax_dist_tolerance), 11.0 + (len(indexes) * ax_dist_tolerance)): 43
        , (11.0 + (len(indexes) * ax_dist_tolerance), 11.25 + (len(indexes) * ax_dist_tolerance)): 44
        , (11.25 + (len(indexes) * ax_dist_tolerance), 11.5 + (len(indexes) * ax_dist_tolerance)): 45
        , (11.5 + (len(indexes) * ax_dist_tolerance), 11.75 + (len(indexes) * ax_dist_tolerance)): 46
        , (11.75 + (len(indexes) * ax_dist_tolerance), 12.0 + (len(indexes) * ax_dist_tolerance)): 47
        , (12.0 + (len(indexes) * ax_dist_tolerance), 12.5 + (len(indexes) * ax_dist_tolerance)): 48
        , (12.5 + (len(indexes) * ax_dist_tolerance), 13.0 + (len(indexes) * ax_dist_tolerance)): 49
        , (13.0 + (len(indexes) * ax_dist_tolerance), 13.5 + (len(indexes) * ax_dist_tolerance)): 50
        , (13.5 + (len(indexes) * ax_dist_tolerance), 14.0 + (len(indexes) * ax_dist_tolerance)): 51
        , (14.0 + (len(indexes) * ax_dist_tolerance), 14.5 + (len(indexes) * ax_dist_tolerance)): 52
        , (14.5 + (len(indexes) * ax_dist_tolerance), 15.0 + (len(indexes) * ax_dist_tolerance)): 53
        , (15.0 + (len(indexes) * ax_dist_tolerance), 15.5 + (len(indexes) * ax_dist_tolerance)): 54
        , (15.5 + (len(indexes) * ax_dist_tolerance), 16.0 + (len(indexes) * ax_dist_tolerance)): 55
        , (16.0 + (len(indexes) * ax_dist_tolerance), 16.5 + (len(indexes) * ax_dist_tolerance)): 56
        , (16.5 + (len(indexes) * ax_dist_tolerance), 17.0 + (len(indexes) * ax_dist_tolerance)): 57
        , (17.0 + (len(indexes) * ax_dist_tolerance), 17.5 + (len(indexes) * ax_dist_tolerance)): 58
        , (17.5 + (len(indexes) * ax_dist_tolerance), 18.0 + (len(indexes) * ax_dist_tolerance)): 59
        , (18.0 + (len(indexes) * ax_dist_tolerance), 18.5 + (len(indexes) * ax_dist_tolerance)): 60
        , (18.5 + (len(indexes) * ax_dist_tolerance), 19.0 + (len(indexes) * ax_dist_tolerance)): 61
        , (19.0 + (len(indexes) * ax_dist_tolerance), 19.6 + (len(indexes) * ax_dist_tolerance)): 62
        , (19.6 + (len(indexes) * ax_dist_tolerance), 20.2 + (len(indexes) * ax_dist_tolerance)): 63
        , (20.2 + (len(indexes) * ax_dist_tolerance), 1000000 + (len(indexes) * ax_dist_tolerance)): 64}

    # indexes = indexes[0:-1]
    # ads = vehicle.find("wim").find("ads").findall("d")

    ads_sum = 0
    # gvw = float(vehicle.find("wim").find("gvw").text) * 0.101972
    for index in indexes:
        ads_sum = ads_sum + float(ads[index])
    ads_sum = round(ads_sum, 5)
    for key, val in list(bk1_constraints.items()):
        if ads_sum >= key[0] and ads_sum < key[1]:
            return val
    return -1


def get_constraint_bki_rt(vehicle, indexes, ax_dist_tolerance, ads):
    bk1_rt_constraints = {(6.6 + (len(indexes) * ax_dist_tolerance), 6.8 + (len(indexes) * ax_dist_tolerance)): 33,
                          (6.8 + (len(indexes) * ax_dist_tolerance), 7.0 + (len(indexes) * ax_dist_tolerance)): 34,
                          (7.0 + (len(indexes) * ax_dist_tolerance), 7.2 + (len(indexes) * ax_dist_tolerance)): 35,
                          (7.2 + (len(indexes) * ax_dist_tolerance), 7.6 + (len(indexes) * ax_dist_tolerance)): 36,
                          (7.6 + (len(indexes) * ax_dist_tolerance), 7.8 + (len(indexes) * ax_dist_tolerance)): 37,
                          (7.8 + (len(indexes) * ax_dist_tolerance), 1000000 + (len(indexes) * ax_dist_tolerance)): 38}
    # ads = vehicle.find("wim").find("ads").findall("d")
    # cnt_ds = 0
    # cnt_ws = 0

    ads_sum = 0
    # gvw = float(vehicle.find("wim").find("gvw").text) * 0.101972
    for index in indexes:
        ads_sum = ads_sum + float(ads[index])
    ads_sum = round(ads_sum, 5)
    for key, val in list(bk1_rt_constraints.items()):
        if ads_sum >= key[0] and ads_sum < key[1]:
            return val
    return -1


def get_constraint_bkiv(vehicle, indexes, ax_dist_tolerance, ads):
    bk4_constraints = {(0, 1.0 + (len(indexes) * ax_dist_tolerance)): 11.5
        , (10.6 + (len(indexes) * ax_dist_tolerance), 11 + (len(indexes) * ax_dist_tolerance)): 51.0
        , (1.0 + (len(indexes) * ax_dist_tolerance), 1.3 + (len(indexes) * ax_dist_tolerance)): 16.0
        , (11.0 + (len(indexes) * ax_dist_tolerance), 11.4 + (len(indexes) * ax_dist_tolerance)): 52.0
        , (1.3 + (len(indexes) * ax_dist_tolerance), 1.8 + (len(indexes) * ax_dist_tolerance)): 18.0
        , (11.4 + (len(indexes) * ax_dist_tolerance), 11.8 + (len(indexes) * ax_dist_tolerance)): 53.0
        , (1.8 + (len(indexes) * ax_dist_tolerance), 2.0 + (len(indexes) * ax_dist_tolerance)): 20.0
        , (11.8 + (len(indexes) * ax_dist_tolerance), 12.2 + (len(indexes) * ax_dist_tolerance)): 54.0
        , (2.0 + (len(indexes) * ax_dist_tolerance), 2.6 + (len(indexes) * ax_dist_tolerance)): 21.0
        , (12.2 + (len(indexes) * ax_dist_tolerance), 12.6 + (len(indexes) * ax_dist_tolerance)): 55.0
        , (2.6 + (len(indexes) * ax_dist_tolerance), 4.4 + (len(indexes) * ax_dist_tolerance)): 24.0
        , (12.6 + (len(indexes) * ax_dist_tolerance), 13.0 + (len(indexes) * ax_dist_tolerance)): 56.0
        , (4.4 + (len(indexes) * ax_dist_tolerance), 4.7 + (len(indexes) * ax_dist_tolerance)): 25.0
        , (13.0 + (len(indexes) * ax_dist_tolerance), 13.4 + (len(indexes) * ax_dist_tolerance)): 57.0
        , (4.7 + (len(indexes) * ax_dist_tolerance), 5.2 + (len(indexes) * ax_dist_tolerance)): 26.0
        , (13.4 + (len(indexes) * ax_dist_tolerance), 13.8 + (len(indexes) * ax_dist_tolerance)): 58.0
        , (5.2 + (len(indexes) * ax_dist_tolerance), 5.4 + (len(indexes) * ax_dist_tolerance)): 27.0
        , (13.8 + (len(indexes) * ax_dist_tolerance), 14.2 + (len(indexes) * ax_dist_tolerance)): 59.0
        , (5.4 + (len(indexes) * ax_dist_tolerance), 5.6 + (len(indexes) * ax_dist_tolerance)): 28.0
        , (14.2 + (len(indexes) * ax_dist_tolerance), 14.6 + (len(indexes) * ax_dist_tolerance)): 60.0
        , (5.6 + (len(indexes) * ax_dist_tolerance), 5.8 + (len(indexes) * ax_dist_tolerance)): 29.0
        , (14.6 + (len(indexes) * ax_dist_tolerance), 15.0 + (len(indexes) * ax_dist_tolerance)): 61.0
        , (5.8 + (len(indexes) * ax_dist_tolerance), 6.0 + (len(indexes) * ax_dist_tolerance)): 30.0
        , (15.0 + (len(indexes) * ax_dist_tolerance), 15.4 + (len(indexes) * ax_dist_tolerance)): 62.0
        , (6.0 + (len(indexes) * ax_dist_tolerance), 6.2 + (len(indexes) * ax_dist_tolerance)): 31.0
        , (15.4 + (len(indexes) * ax_dist_tolerance), 15.8 + (len(indexes) * ax_dist_tolerance)): 63.0
        , (6.2 + (len(indexes) * ax_dist_tolerance), 6.4 + (len(indexes) * ax_dist_tolerance)): 32.0
        , (15.8 + (len(indexes) * ax_dist_tolerance), 16.2 + (len(indexes) * ax_dist_tolerance)): 64.0
        , (6.4 + (len(indexes) * ax_dist_tolerance), 6.8 + (len(indexes) * ax_dist_tolerance)): 33.0
        , (16.2 + (len(indexes) * ax_dist_tolerance), 16.6 + (len(indexes) * ax_dist_tolerance)): 65.0
        , (6.8 + (len(indexes) * ax_dist_tolerance), 7.0 + (len(indexes) * ax_dist_tolerance)): 34.0
        , (16.6 + (len(indexes) * ax_dist_tolerance), 17.0 + (len(indexes) * ax_dist_tolerance)): 66.0
        , (7.0 + (len(indexes) * ax_dist_tolerance), 7.2 + (len(indexes) * ax_dist_tolerance)): 35.0
        , (17.0 + (len(indexes) * ax_dist_tolerance), 17.4 + (len(indexes) * ax_dist_tolerance)): 67.0
        , (7.2 + (len(indexes) * ax_dist_tolerance), 7.6 + (len(indexes) * ax_dist_tolerance)): 36.0
        , (17.4 + (len(indexes) * ax_dist_tolerance), 17.8 + (len(indexes) * ax_dist_tolerance)): 68.0
        , (7.6 + (len(indexes) * ax_dist_tolerance), 7.8 + (len(indexes) * ax_dist_tolerance)): 37.0
        , (17.8 + (len(indexes) * ax_dist_tolerance), 18.2 + (len(indexes) * ax_dist_tolerance)): 69.0
        , (7.8 + (len(indexes) * ax_dist_tolerance), 8.0 + (len(indexes) * ax_dist_tolerance)): 38.0
        , (18.2 + (len(indexes) * ax_dist_tolerance), 18.7 + (len(indexes) * ax_dist_tolerance)): 70.0
        , (8.0 + (len(indexes) * ax_dist_tolerance), 8.2 + (len(indexes) * ax_dist_tolerance)): 39.0
        , (18.7 + (len(indexes) * ax_dist_tolerance), 19.2 + (len(indexes) * ax_dist_tolerance)): 71.0
        , (8.2 + (len(indexes) * ax_dist_tolerance), 8.4 + (len(indexes) * ax_dist_tolerance)): 40.0
        , (19.2 + (len(indexes) * ax_dist_tolerance), 19.7 + (len(indexes) * ax_dist_tolerance)): 72.0
        , (8.4 + (len(indexes) * ax_dist_tolerance), 8.6 + (len(indexes) * ax_dist_tolerance)): 41.0
        , (19.7 + (len(indexes) * ax_dist_tolerance), 20.2 + (len(indexes) * ax_dist_tolerance)): 73.0
        , (8.6 + (len(indexes) * ax_dist_tolerance), 8.8 + (len(indexes) * ax_dist_tolerance)): 42.0
        , (20.2 + (len(indexes) * ax_dist_tolerance), 1000000 + (len(indexes) * ax_dist_tolerance)): 74.0
        , (8.8 + (len(indexes) * ax_dist_tolerance), 9.0 + (len(indexes) * ax_dist_tolerance)): 43.0
        , (9.0 + (len(indexes) * ax_dist_tolerance), 9.2 + (len(indexes) * ax_dist_tolerance)): 44.0
        , (9.2 + (len(indexes) * ax_dist_tolerance), 9.4 + (len(indexes) * ax_dist_tolerance)): 45.0
        , (9.4 + (len(indexes) * ax_dist_tolerance), 9.6 + (len(indexes) * ax_dist_tolerance)): 46.0
        , (9.6 + (len(indexes) * ax_dist_tolerance), 9.8 + (len(indexes) * ax_dist_tolerance)): 47.0
        , (9.8 + (len(indexes) * ax_dist_tolerance), 10.0 + (len(indexes) * ax_dist_tolerance)): 48.0
        , (10.0 + (len(indexes) * ax_dist_tolerance), 10.2 + (len(indexes) * ax_dist_tolerance)): 49.0
        , (10.2 + (len(indexes) * ax_dist_tolerance), 10.6 + (len(indexes) * ax_dist_tolerance)): 50.0}

    # indexes = indexes[0:-1]
    # ads = vehicle.find("wim").find("ads").findall("d")

    ads_sum = 0
    # gvw = float(vehicle.find("wim").find("gvw").text) * 0.101972
    for index in indexes:
        ads_sum = ads_sum + float(ads[index])
    ads_sum = round(ads_sum, 5)
    for key, val in list(bk4_constraints.items()):
        if ads_sum >= key[0] and ads_sum < key[1]:
            return val
    return -1


def get_all_possible_axle_combinations(ax_count, conf, vehicle):
    cls = vehicle.find("wim").find("cls").text
    conf_scls = "subclass_" + cls
    ax_config = conf.get(conf_scls, "axle_configuration")
    modules = re.findall('..', ax_config)

    globul = 0
    axles = list()
    for i in range(len(modules)):
        ac_count = int(modules[i][1])
        for j in range(ac_count):
            axles.append((globul, i, modules[i][0]))
            globul += 1

    # combs_to_modules = dict()
    # combinations = [axles[i:j] for i, j in itertools.combinations(range(ax_count+1), 2)]
    return [axles[i:j] for i, j in itertools.combinations(list(range(ax_count + 1)), 2)]


def get_constraint(grp_indexes, cls, conf, idx, gvw):
    try:
        conf_scls = "subclass_" + cls
        conf_axle_weight_str = conf.get(conf_scls, "max_axle_weight__kN")
        parts = conf_axle_weight_str.split(";")
        tmp_dict = dict()
        for part in parts:
            sub_parts = part.split(",")
            tmp_dict[sub_parts[0]] = float(sub_parts[1])
        if len(grp_indexes) == 1:
            if str(int(grp_indexes[0]) + 1) in tmp_dict:
                if round(float(kn_to_t(tmp_dict[str(int(grp_indexes[0]) + 1)])), 1) == 11.5:
                    return 11.5
                else:
                    return 10.0
            else:
                return 10.0
        elif len(grp_indexes) == 2:
            if str(int(grp_indexes[0]) + 1) + "+" + str(int(grp_indexes[1]) + 1) in tmp_dict:
                if round(float(kn_to_t(
                        tmp_dict[str(int(grp_indexes[0]) + 1) + "+" + str(int(grp_indexes[1]) + 1)]))) == 19.0:
                    return 19.0
                else:
                    return 18.0
            else:
                return 18.0
    except Exception as ex:
        # print str(ex)
        if cls == "140":
            # if gvw <= 8:
            #  if idx == 1:
            #    if len(grp_indexes) == 1:
            #      return 11.5
            #    if len(grp_indexes) == 2:
            #      return 18
            #  else:
            #    if len(grp_indexes) == 1:
            #      return 10
            #    if len(grp_indexes) == 2:
            #      return 19
            # else:
            if idx == 1:
                if len(grp_indexes) == 1:
                    return 11.5
                if len(grp_indexes) == 2:
                    return 19
            else:
                if len(grp_indexes) == 1:
                    return 10
                if len(grp_indexes) == 2:
                    return 18
        return -1

def excel_date(date1):
    temp = datetime.datetime(1899, 12, 30)
    d1object = datetime.datetime.strptime(date1, "%Y-%m-%d-%H-%M-%S-%f")
    delta = d1object - temp
    return float(delta.days) + (float(delta.seconds) / 86400)

def regroupify(vehicle, tolerance, conf, bk, ax_dist_tolerance, ads, acws):
    """Calculate grps with TA tolerance"""

    try:
        # ads = vehicle.find("wim").find("ads").findall("d")
        naxles = int(vehicle.find("wim").find("naxles").text)
        cls = vehicle.find("wim").find("cls").text
        # nruples = collections.OrderedDict()
        # acws = vehicle.find("wim").find("acws").findall("w")
        nruples = collections.OrderedDict()
        sextruples = collections.OrderedDict()
        pentruples = collections.OrderedDict()
        quadruples = collections.OrderedDict()
        doubles = collections.OrderedDict()
        triples = collections.OrderedDict()
        singles = collections.OrderedDict()

        index = 0
        ts = vehicle.find("wim").find("ts").text
        weights = list()
        for acw in acws:
            # weights.append(float(kn_to_t(acw.text)))
            weights.append(float(kn_to_t(acw)))
        # all possible single axles
        for i in range(naxles):
            tmp = [i, ]
            constraint = get_constraint(tmp, cls, conf, i, sum(weights))
            name = "S11.5"
            if constraint == 10 or constraint == -1:
                constraint = 10
                name = "S10"
            else:
                constraint = 11.5
            singles[(index, 1, name, constraint, 10, sum(weights[tmp[0]:tmp[0] + 1]))] = tmp
            index += 1

        # all possible n-sized groups (n > 6)
        potential_grp_size = naxles
        while potential_grp_size > 6:
            i = 0
            prev_tmp = list()
            prev_key = None
            prev_sum = 2 + potential_grp_size + 0.1
            while i < len(ads):
                if (i + (potential_grp_size - 2)) < len(ads):
                    nruple_sum = 0
                    tmp = list()
                    ads_avg = 0
                    for j in range(i, i + (potential_grp_size - 1)):
                        ads_avg += float(ads[j])
                        # ads_avg += float(ads[j].text)
                    ads_avg = ads_avg / (potential_grp_size - 1)
                    for j in range(i, i + (potential_grp_size - 1)):
                        # if j >= i and abs((float(ads[j].text) - ads_avg)) / ads_avg > tolerance:
                        if j >= i and abs((float(ads[j]) - ads_avg)) / ads_avg > tolerance:

                            nruple_sum = 2 + potential_grp_size + 0.1
                            break
                        nruple_sum += float(ads[j])
                        # nruple_sum += float(ads[j].text)
                    nruple_sum = round(nruple_sum, 5)
                    if nruple_sum <= ((2 + potential_grp_size) + ax_dist_tolerance * (potential_grp_size - 1)):
                        familiar = False
                        for j in range(i, i + (potential_grp_size) - 1):
                            if j in prev_tmp or j + 1 in prev_tmp or j - 1 in prev_tmp:
                                familiar = True
                            tmp.append(j)
                        if familiar:
                            if len(tmp) > len(prev_tmp) or len(tmp) == len(prev_tmp) and nruple_sum < prev_sum:
                                if prev_key != None:
                                    del (nruples[prev_key])
                            else:
                                i += 1
                                continue
                        constraint = -1
                        if bk == "bk1":
                            constraint = get_constraint_bki(vehicle, tmp, ax_dist_tolerance, ads)
                        elif bk == "bk4":
                            constraint = get_constraint_bkiv(vehicle, tmp, ax_dist_tolerance, ads)
                        key = (index, len(tmp) + 1, "X", constraint, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                        nruples[key] = tmp
                        index += 1
                        # i = i + potential_grp_size
                        # continue
                        prev_sum = nruple_sum
                        prev_tmp = tmp
                        prev_key = key
                i += 1
            potential_grp_size -= 1

        used = list()
        for key in list(nruples.keys()):
            at_least_one_used = False
            for ax in nruples[key]:
                if ax in used or (ax + 1) in used:
                    at_least_one_used = True
                    break
            if not at_least_one_used:
                for ax in nruples[key]:
                    used.append(ax)
                used.append(nruples[key][len(nruples[key]) - 1] + 1)
                nruples[key].append(nruples[key][len(nruples[key]) - 1] + 1)

        i = 0
        prev_tmp = list()
        prev_key = None
        prev_sum = 8.1
        while i < len(ads):
            if i in used or (i + 1) in used:
                i += 1
                continue
            key = None
            if (i + 4) < len(ads):
                sextruple_sum = 0
                tmp = list()
                ads_avg = 0
                for j in range(i, i + 5):
                    ads_avg += float(ads[j])
                    # ads_avg += float(ads[j].text)
                ads_avg = ads_avg / 5
                for j in range(i, i + 5):
                    # if j >= i and abs((float(ads[j].text) - ads_avg)) / ads_avg > tolerance:
                    if j >= i and abs((float(ads[j]) - ads_avg)) / ads_avg > tolerance:

                        sextruple_sum = 8.1
                        break
                    sextruple_sum += float(ads[j])
                    # sextruple_sum += float(ads[j].text)
                sextruple_sum = round(sextruple_sum, 5)
                if sextruple_sum < 8.0 + (ax_dist_tolerance * 5):
                    familiar = False
                    for j in range(i, i + 5):
                        if j in prev_tmp or j + 1 in prev_tmp or j - 1 in prev_tmp:
                            familiar = True
                        tmp.append(j)
                    if familiar:
                        if sextruple_sum < prev_sum:
                            if prev_key != None:
                                del (sextruples[prev_key])
                        else:
                            i += 1
                            continue
                    if bk == "bk1":
                        constraint = get_constraint_bki(vehicle, tmp, ax_dist_tolerance, ads)
                    elif bk == "bk4":
                        constraint = get_constraint_bkiv(vehicle, tmp, ax_dist_tolerance, ads)
                    """if sextruple_sum >= 7.0 + ax_dist_tolerance*5:
                      key = (index, 6, "Sex" + str(min(int(constraint), 38)), constraint, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif sextruple_sum >= 6.0 + ax_dist_tolerance*5:
                      key = (index, 6, "Sex" + str(int(constraint)), constraint, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif sextruple_sum >= 5.8 + ax_dist_tolerance*5:
                      key = (index, 6, "Sex30", 30, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif sextruple_sum >= 5.6 + ax_dist_tolerance*5:
                      key = (index, 6, "Sex29", 29, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif sextruple_sum >= 5.4 + ax_dist_tolerance*5:
                      key = (index, 6, "Sex28", 28, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif sextruple_sum >= 5.2 + ax_dist_tolerance*5:
                      key = (index, 6, "Sex27", 27, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif sextruple_sum >= 4.7 + ax_dist_tolerance*5:
                      key = (index, 6, "Sex26", 26, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif sextruple_sum >= 4.4 + ax_dist_tolerance*5:
                      key = (index, 6, "Sex25", 25, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif sextruple_sum >= 2.6 + ax_dist_tolerance*5:
                      key = (index, 6, "Sex24", 24, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif sextruple_sum < 2.6 + ax_dist_tolerance*5:
                      key = (index, 6, "Sex21", 21, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))"""
                    key = (index, 6, "Sex38", constraint, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    sextruples[key] = tmp
                    index += 1
                    # i = i + 6
                    prev_sum = sextruple_sum
                    prev_tmp = tmp
                    prev_key = key
                    # continue
            i += 1

        for key in list(sextruples.keys()):
            at_least_one_used = False
            for ax in sextruples[key]:
                if ax in used or (ax + 1) in used:
                    at_least_one_used = True
                    break
            if not at_least_one_used:
                for ax in sextruples[key]:
                    used.append(ax)
                used.append(sextruples[key][4] + 1)
                sextruples[key].append(sextruples[key][4] + 1)
        i = 0
        # print "a"
        prev_tmp = list()
        prev_key = None
        prev_sum = 8.1
        while i < len(ads):
            # if ts == "2019-04-02-12-09-10-757":
            # print "-----"
            if i in used or (i + 1) in used:
                i += 1
                continue
            key = None
            if (i + 3) < len(ads):
                pentruple_sum = 0
                tmp = list()
                ads_avg = 0
                for j in range(i, i + 4):
                    ads_avg += float(ads[j])
                    # ads_avg += float(ads[j].text)
                ads_avg = ads_avg / 4
                for j in range(i, i + 4):
                    if j >= i and abs((float(ads[j]) - ads_avg)) / ads_avg > tolerance:
                    # if j >= i and abs((float(ads[j].text) - ads_avg)) / ads_avg > tolerance:
                        pentruple_sum = 8.1
                        break
                    pentruple_sum += float(ads[j])
                    # pentruple_sum += float(ads[j].text)
                pentruple_sum = round(pentruple_sum, 5)
                if pentruple_sum < 7.0 + (ax_dist_tolerance * 4):
                    familiar = False
                    for j in range(i, i + 4):
                        if j in prev_tmp or j + 1 in prev_tmp or j - 1 in prev_tmp:
                            familiar = True
                        tmp.append(j)
                    if familiar:
                        if pentruple_sum < prev_sum:
                            if prev_key != None:
                                del (pentruples[prev_key])
                        else:
                            i += 1
                            continue
                    if bk == "bk1":
                        constraint = get_constraint_bki(vehicle, tmp, ax_dist_tolerance, ads)
                    elif bk == "bk4":
                        constraint = get_constraint_bkiv(vehicle, tmp, ax_dist_tolerance, ads)
                    """if pentruple_sum >= 6.0 + ax_dist_tolerance*4:
                      key = (index, 5, "Fem" + str(int(constraint)), constraint, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif pentruple_sum >= 5.8 + ax_dist_tolerance*4:
                      key = (index, 5, "Fem30", 30, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif pentruple_sum >= 5.6 + ax_dist_tolerance*4:
                      key = (index, 5, "Fem29", 29, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif pentruple_sum >= 5.4 + ax_dist_tolerance*4:
                      key = (index, 5, "Fem28", 28, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif pentruple_sum >= 5.2 + ax_dist_tolerance*4:
                      key = (index, 5, "Fem27", 27, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif pentruple_sum >= 4.7 + ax_dist_tolerance*4:
                      key = (index, 5, "Fem26", 26, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif pentruple_sum >= 4.4 + ax_dist_tolerance*4:
                      key = (index, 5, "Fem25", 25, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif pentruple_sum >= 2.6 + ax_dist_tolerance*4:
                      key = (index, 5, "Fem24", 24, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif pentruple_sum < 2.6 + ax_dist_tolerance*4:
                      key = (index, 5, "Fem21", 21, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))"""
                    key = (index, 5, "Fem34", constraint, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    pentruples[key] = tmp
                    index += 1
                    prev_sum = pentruple_sum
                    prev_tmp = tmp
                    prev_key = key
            i += 1

        for key in list(pentruples.keys()):
            at_least_one_used = False
            for ax in pentruples[key]:
                if ax in used or (ax + 1) in used:
                    at_least_one_used = True
                    break
            if not at_least_one_used:
                for ax in pentruples[key]:
                    used.append(ax)
                used.append(pentruples[key][3] + 1)
                pentruples[key].append(pentruples[key][3] + 1)
        i = 0
        prev_tmp = list()
        prev_key = None
        prev_sum = 8.1
        while i < len(ads):
            if i in used or (i + 1) in used:
                i += 1
                continue
            key = None
            if (i + 2) < len(ads):
                quadruple_sum = 0
                tmp = list()
                ads_avg = 0
                for j in range(i, i + 3):
                    ads_avg += float(ads[j])
                    # ads_avg += float(ads[j].text)
                ads_avg = ads_avg / 3
                for j in range(i, i + 3):
                    if j >= i and abs((float(ads[j]) - ads_avg)) / ads_avg > tolerance:
                    # if j >= i and abs((float(ads[j].text) - ads_avg)) / ads_avg > tolerance:
                        quadruple_sum = 8.1
                        break
                    quadruple_sum += float(ads[j])
                    # quadruple_sum += float(ads[j].text)
                quadruple_sum = round(quadruple_sum, 5)
                if quadruple_sum < 6.0 + (ax_dist_tolerance * 3):
                    familiar = False
                    for j in range(i, i + 3):
                        if j in prev_tmp or j + 1 in prev_tmp or j - 1 in prev_tmp:
                            familiar = True
                        tmp.append(j)
                    if familiar:
                        if quadruple_sum < prev_sum:
                            if prev_key != None:
                                del (quadruples[prev_key])
                        else:
                            i += 1
                            continue
                    if bk == "bk1":
                        constraint = get_constraint_bki(vehicle, tmp, ax_dist_tolerance, ads)
                    elif bk == "bk4":
                        constraint = get_constraint_bkiv(vehicle, tmp, ax_dist_tolerance, ads)
                    """if quadruple_sum >= 5.8 + ax_dist_tolerance*3:
                      key = (index, 4, "Fyr30", 30, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif quadruple_sum >= 5.6 + ax_dist_tolerance*3:
                      key = (index, 4, "Fyr29", 29, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif quadruple_sum >= 5.4 + ax_dist_tolerance*3:
                      key = (index, 4, "Fyr28", 28, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif quadruple_sum >= 5.2 + ax_dist_tolerance*3:
                      key = (index, 4, "Fyr27", 27, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif quadruple_sum >= 4.7 + ax_dist_tolerance*3:
                      key = (index, 4, "Fyr26", 26, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif quadruple_sum >= 4.4 + ax_dist_tolerance*3:
                      key = (index, 4, "Fyr25", 25, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif quadruple_sum >= 2.6 + ax_dist_tolerance*3:
                      key = (index, 4, "Fyr24", 24, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    elif quadruple_sum < 2.6 + ax_dist_tolerance*3:
                      key = (index, 4, "Fyr21", 21, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))"""
                    key = (index, 4, "Fyr30", constraint, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                    quadruples[key] = tmp
                    index += 1
                    # quadruples.append(tmp)
                    # i = i + 4
                    prev_sum = quadruple_sum
                    prev_tmp = tmp
                    prev_key = key
                    # continue
            i += 1
        # print "c"

        for key in list(quadruples.keys()):
            at_least_one_used = False
            for ax in quadruples[key]:
                if ax in used or (ax + 1) in used:
                    at_least_one_used = True
                    break
            if not at_least_one_used:
                for ax in quadruples[key]:
                    used.append(ax)
                used.append(quadruples[key][2] + 1)
                quadruples[key].append(quadruples[key][2] + 1)
        i = 0
        prev_tmp = list()
        prev_key = None
        prev_sum = 8.1
        while i < len(ads):
            if i in used or (i + 1) in used:
                i += 1
                continue
            key = None
            if (i + 1) < len(ads):
                triple_sum = 0
                tmp = list()
                ads_avg = 0
                for j in range(i, i + 2):
                    # ads_avg += float(ads[j].text)
                    ads_avg += float(ads[j])
                ads_avg = ads_avg / 2
                for j in range(i, i + 2):
                    # print abs((float(ads[j].text) - float(ads[j - 1].text))) / float(ads[j].text)
                    if j >= i and abs((float(ads[j]) - ads_avg)) / ads_avg > tolerance:
                    # if j >= i and abs((float(ads[j].text) - ads_avg)) / ads_avg > tolerance:
                        triple_sum = 8.1
                        break
                    triple_sum += float(ads[j])
                    # triple_sum += float(ads[j].text)
                # print triple_sum
                # print "jej"
                triple_sum = round(triple_sum, 5)
                if triple_sum < 5.0 + (ax_dist_tolerance * 2):
                    # print weights[tmp[0]:tmp[len(tmp) - 1] + 2]
                    familiar = False
                    for j in range(i, i + 2):
                        if j in prev_tmp or j + 1 in prev_tmp or j - 1 in prev_tmp:
                            familiar = True
                        tmp.append(j)
                    if familiar:
                        if triple_sum < prev_sum:
                            if prev_key != None:
                                del (triples[prev_key])
                        else:
                            i += 1
                            continue
                    # print weights[tmp[0]:tmp[len(tmp) - 1] + 2]
                    # print sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2])
                    # print "joj"
                    if triple_sum >= 4.7 + ax_dist_tolerance * 2:
                        key = (index, 3, "T26", 26, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                        # triples[(index, 3, "T26", 26, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))] = tmp
                    elif triple_sum >= 4.4 + ax_dist_tolerance * 2:
                        key = (index, 3, "T25", 25, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                        # triples[(index, 3, "T25", 25, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))] = tmp
                    elif triple_sum >= 2.6 + ax_dist_tolerance * 2:
                        key = (index, 3, "T24", 24, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                        # triples[(index, 3, "T24", 24, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))] = tmp
                    elif triple_sum < 2.6 + ax_dist_tolerance * 2:
                        key = (index, 3, "T21", 21, 24, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))

                    triples[key] = tmp
                    index += 1
                    prev_sum = triple_sum
                    prev_tmp = tmp
                    prev_key = key
                    # triples.append(tmp)
                    # i = i + 3
                    # continue
            i += 1
        # print "a"
        # print "lal"
        # print "d"
        for key in list(triples.keys()):
            at_least_one_used = False
            for ax in triples[key]:
                if ax in used or (ax + 1) in used:
                    at_least_one_used = True
                    break
            if not at_least_one_used:
                for ax in triples[key]:
                    used.append(ax)
                used.append(triples[key][1] + 1)
                triples[key].append(triples[key][1] + 1)
        i = 0
        prev_sum = 2.0
        prev_key = None
        while i < len(ads):
            if i in used or (i + 1) in used:
                i += 1
                prev_key = None
                prev_sum = 2.0
                continue
            # if float(ads[i].text) < 2.0 + ax_dist_tolerance:
            if float(ads[i]) < 2.0 + ax_dist_tolerance:
                key = None
                tmp = list()
                tmp.append(i)
                if prev_sum > float(ads[i]) and prev_sum != 2.0:
                # if prev_sum > float(ads[i].text) and prev_sum != 2.0:
                    del (doubles[prev_key])
                # if float(ads[i].text) >= 1.8 + ax_dist_tolerance:
                if float(ads[i]) >= 1.8 + ax_dist_tolerance:
                    key = (index, 2, "B20", 20, 18, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                # elif float(ads[i].text) >= 1.3 + ax_dist_tolerance:
                elif float(ads[i]) >= 1.3 + ax_dist_tolerance:
                    constraint = get_constraint(tmp + [tmp[0] + 1, ], cls, conf, i, sum(weights))
                    name = "B18"
                    if constraint == 19 or constraint == -1:
                        constraint = 19
                        name = "B19"
                    key = (index, 2, name, constraint, 18, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                elif float(ads[i]) >= 1.0 + ax_dist_tolerance:
                # elif float(ads[i].text) >= 1.0 + ax_dist_tolerance:
                    key = (index, 2, "B16", 16, 18, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                # elif float(ads[i].text) < 1.0 + ax_dist_tolerance:
                elif float(ads[i]) < 1.0 + ax_dist_tolerance:
                    key = (index, 2, "B11.5", 11.5, 18, sum(weights[tmp[0]:tmp[len(tmp) - 1] + 2]))
                # doubles.append([i])
                doubles[key] = tmp
                prev_key = key
                # prev_sum = float(ads[i].text)
                prev_sum = float(ads[i])
                index += 1
                # i += 1
                # continue
            else:
                prev_key = None
                prev_sum = 2.0
            i += 1

        for key in list(doubles.keys()):
            at_least_one_used = False
            for ax in doubles[key]:
                if ax in used or (ax + 1) in used:
                    at_least_one_used = True
                    break
            if not at_least_one_used:
                for ax in doubles[key]:
                    used.append(ax)
                used.append(doubles[key][0] + 1)
                doubles[key].append(doubles[key][0] + 1)
        # --------------


        # -------------
        i = 0
        grps_str = ""
        grps_list = list()
        grps_cnt = 0
        while i < naxles:
            grps_cnt += 1
            found = False
            for key, val in list(nruples.items()):
                if len(val) > 6 and i in val:
                    grps_str += "X"
                    i += len(val)
                    grps_list.append(key)
                    found = True
                    break
            if found:
                continue
            for key, val in list(sextruples.items()):
                if len(val) == 6 and i in val:
                    grps_str += "6"
                    i += 6
                    grps_list.append(key)
                    found = True
                    break
            if found:
                continue
            for key, val in list(pentruples.items()):
                if len(val) == 5 and i in val:
                    grps_str += "5"
                    i += 5
                    grps_list.append(key)
                    found = True
                    break
            if found:
                continue
            for key, val in list(quadruples.items()):
                if len(val) == 4 and i in val:
                    grps_str += "4"
                    i += 4
                    grps_list.append(key)
                    found = True
                    break
            if found:
                continue
            for key, val in list(triples.items()):
                if len(val) == 3 and i in val:
                    grps_str += "3"
                    i += 3
                    grps_list.append(key)
                    found = True
                    break
            if found:
                continue
            for key, val in list(doubles.items()):
                # print(key)
                # print(val)
                if len(val) == 2 and i in val:
                    grps_str += "2"
                    i += 2
                    if grps_cnt == 2 and cls == "140" and key[2] == "B18":
                        grps_list.append((key[0], 2, "B19", 19, 18, key[5]))
                    else:
                        grps_list.append(key)

                    """if cls == "202" and grps_cnt == 2:
                      grps_list.append((key[0], 2, "B18", 18, 18, key[5]))
                    elif cls == "203" and grps_cnt == 3:
                      grps_list.append((key[0], 2, "B18", 18, 18, key[5]))
                    elif cls == "206" and grps_cnt == 2:
                      grps_list.append((key[0], 2, "B18", 18, 18, key[5]))"""

                    # print val
                    found = True
                    break
            if found:
                continue
            for key, val in list(singles.items()):
                # print val
                if len(val) == 1 and i in val:
                    grps_str += "1"
                    if grps_cnt == 2 and cls == "140":
                        grps_list.append((key[0], 1, "S11.5", 11.5, 10, key[5]))
                    else:
                        grps_list.append(key)
                    # grps_list.append(key)
                    break
            i += 1

        # if len(grps_list[]
        # print grps_list
        # print weights
        # if ts == "2019-04-02-12-09-10-757":
        # print grps_list
        # print "lel"
        # print grps_list
        return grps_list
    except Exception as ex:
        print(str(ex))
        return []

def is_overloaded_by_axles(axle_list):
    for grp in axle_list:
        if grp[5] > grp[3]:
            return True
    return False

def calculate_module_distances(vehicle, conf, grps, ads):
    scls = vehicle.find("wim").find("cls").text
    if scls == "140":
        return None

    # distances = vehicle.find("wim").find("ads").findall("d")
    conf_scls = "subclass_" + scls
    axle_configuration = conf.get(conf_scls, "axle_configuration")

    modules = re.findall('..', axle_configuration)
    module_id = 0
    grps_sum = 0

    last_axles = list()
    first_axles = list()

    # sanity
    for grp in grps:
        module_cnt = int(modules[module_id][1])
        grps_sum += grp[1]
        if grps_sum == grp[1]:
            first_axles.append(grp[1])
        if grps_sum == module_cnt:
            grps_sum = 0
            module_id += 1
            last_axles.append(grp[1])
        elif grps_sum > module_cnt:
            fd = open("module_distance_err_timestamps.txt", "a")
            fd.write(vehicle.find("wim").find("ts").text)
            fd.close()
            return None

    master_list = list()

    typ_ax_count_pairs = list()
    typ = ""
    cnt = ""
    for i in range(len(axle_configuration)):
        a = axle_configuration[i]
        if a.isalpha():
            if typ != "":
                typ_ax_count_pairs.append((typ + str(cnt), int(cnt) - 1))
                cnt = ""
            typ = a
        else:
            cnt += a
            if i == len(axle_configuration) - 1:
                if typ != "":
                    typ_ax_count_pairs.append((typ, int(cnt) - 1))
    # print "---"
    # print axle_configuration

    # print typ_ax_count_pairs
    # print "---"
    # previous_dist = 0

    # first = True
    master_list.append((typ_ax_count_pairs[0][0], 0))
    # global_idx = 0
    # for dist in distances:
    # print dist.text
    global_idx = typ_ax_count_pairs[0][1]
    for i in range(1, len(typ_ax_count_pairs)):
        typ_ax_count_pair = typ_ax_count_pairs[i]
        # global_idx+=typ_ax_count_pair[1]
        typ = typ_ax_count_pair[0]
        # module, distance, last (axle group size) in previous modue, first in this module
        master_list.append((
                           # str(typ_ax_count_pair[0]) + str(typ_ax_count_pair[1] + 1), float(distances[global_idx].text),
                           # last_axles[i - 1], first_axles[i]))
            str(typ_ax_count_pair[0]) + str(typ_ax_count_pair[1] + 1), float(ads[global_idx]),
            last_axles[i - 1], first_axles[i]))
        global_idx += typ_ax_count_pair[1]
        global_idx += 1

        # for idx in range(typ_ax_count_pair[1]):
        # print(distances[global_idx].text)
        # global_idx+=1

        # if global_idx > len(distances)-1:
        # continue
        # print global_idx
        # global_idx+=1

        # if first:
        # master_list.append((typ, 0))
        # first = False
        # global_idx+=1

        # global_idx+=1

    return master_list

def is_gvw_overloaded(vehicle, conf, bk, grps, ads, acws, gvw):
    try:
        # ts = vehicle.find("wim").find("ts").text
        # gvw = float(kn_to_t(vehicle.find("wim").find("gvw").text))
        strg = list()
        # strg.append(ts)
        naxles = int(vehicle.find("wim").find("naxles").text)
        # acws = vehicle.find("wim").find("acws").findall("w")

        constraints = list()
        num_of_axles = int(vehicle.find("wim").find("naxles").text)

        # grp_max = 0
        # for grp in grps.keys():
        # grp_max+=grp[3]

        # constraints.append(grp_max)

        # ovr = False
        if bk == "bk1":
            constraints.append(64.0)
            if gvw > 64.0:
                # print vehicle.find("wim").find("gvw").text
                # ovr = True
                strg.append("global bk1 constraint")
                # return True
        elif bk == "bk4":
            constraints.append(74.0)
            if gvw > 74.0:
                # ovr = True
                strg.append("global bk4 constraint")
                # return True

        # bk_cons = conf_gvw

        bk_constraint = 1000000000
        if bk == "bk1":
            # print "lal"
            tmp = get_constraint_bki(vehicle, list(range(num_of_axles - 1)), 0, ads)
            # print "lel"
            # if tmp > -1:
            # constraints.append(tmp)
            bk_constraint = tmp
            # print ts + ": " + str(tmp) + "t"
            # conf_gvw = tmp

        elif bk == "bk4":
            tmp = get_constraint_bkiv(vehicle, list(range(num_of_axles - 1)), 0, ads)
            # if tmp > -1:
            # if conf_gvw != tmp:
            bk_constraint = tmp
            # print ts + ": " + str(tmp) + "t"
            # conf_gvw = tmp
            # if gvw > 74.0:
            # return True
        # if conf_gvw < gvw:
        # if ts == "2019-04-01-00-03-40-564":
        # print constraint
        constraints.append(bk_constraint)
        if gvw > bk_constraint:
            strg.append("bk length constraint")
            # ovr = True

        cls = vehicle.find("wim").find("cls").text

        if cls == "140" or bk == "bk4":
            gprsss_sum = 0
            gprsss_max_sum = 0
            for grp in grps:
                gprsss_sum += grp[5]
                gprsss_max_sum += grp[3]
            constraints.append(gprsss_max_sum)
            if gprsss_max_sum < gprsss_sum:
                strg.append("grp max sum constraint")

        if cls != "140":
            conf_scls = "subclass_" + cls
            conf_gvw = float(kn_to_t(conf.get(conf_scls, "max_GVW__kN")))
            if bk != "bk4":
                if gvw > conf_gvw:
                    strg.append("classes constraint")
                    # ovr = True
                constraints.append(conf_gvw)

                ### vse medosne razdalje med posameznimi konfiguracijskimi enotami
            distances = calculate_module_distances(vehicle, conf, grps, ads)
            # print distances
            # if len(distances) >= 2:
            # print "a"
            broken = False

            ### preverba vseh medosnih razdalj

            for i in range(1, len(distances)):
                # if distances[i][0][0] == "T" or bk == "bk1" and distances[i][0][0] == "S" and distances[i][1] < 5 or bk == "bk4" and distances[i][0][0] == "S" and distances[i][1] < 4:
                # print "b"
                # if distances[i][0][0] == "T" and int(distances[i][0][1:len(distances[i][0])]) < 4 and distances[i][1] > 3 or distances[i][0][0] == "T" and int(distances[i][0][1:len(distances[i][0])]) >= 4 and distances[i][1] > 4:
                # continue
                if (distances[i][2] == 1 and distances[i][3] >= 1 and distances[i][1] < 3 or
                        distances[i][2] >= 1 and distances[i][3] == 1 and distances[i][1] < 3 or
                        bk == "bk4" and distances[i][2] >= 2 and distances[i][3] == 2 and distances[i][1] < 4 or
                        bk == "bk4" and distances[i][2] == 2 and distances[i][3] >= 2 and distances[i][1] < 4 or
                        bk == "bk1" and distances[i][2] == 2 and distances[i][3] == 2 and distances[i][1] < 4 or
                        bk == "bk1" and distances[i][2] >= 3 and distances[i][3] == 2 and distances[i][1] < 5 or
                        bk == "bk1" and distances[i][2] == 2 and distances[i][3] >= 3 and distances[i][1] < 5 or
                        bk == "bk1" and distances[i][2] >= 3 and distances[i][3] >= 3 and distances[i][1] < 5):
                    # and distances[i][1] < 3
                    axle_combinations = get_all_possible_axle_combinations(naxles, conf, vehicle)
                    for axle_combination in axle_combinations:
                        if len(axle_combination) == 1:
                            continue
                        right_table_candidate = True
                        flag_1 = False
                        flag_2 = False
                        # towing_types = ["h", "l", "c", "v", "a", "b"]
                        axle_combinationn = list()
                        # first = True
                        typeee = ""
                        mod_id = 0
                        for k in range(len(axle_combination)):
                            # if k == 0:

                            # mod_id = axle_combination[k][1]
                            # first = False
                            # else:
                            typeee = axle_combination[k][2]
                            # if typeee.lower() in towing_types:
                            # right_table_possible_candidate = True
                            if typeee.lower() != "t" and typeee.lower() != "s" and typeee.lower() != "d":
                                right_table_candidate = False
                                flag_1 = True
                            else:
                                flag_2 = True
                            axle_combinationn.append(axle_combination[k][0])
                        right_table_possible_candidate = flag_1 and flag_2
                        bkonstraint = None
                        if bk == "bk1":
                            bkonstraint = get_constraint_bki(vehicle, axle_combinationn[:-1], 0, ads)
                            if right_table_candidate:
                                right_constraint = get_constraint_bki_rt(vehicle, axle_combinationn[:-1], 0, ads)
                                if right_constraint != -1:
                                    bkonstraint = right_constraint
                            elif right_table_possible_candidate:
                                bkonstraint = get_constraint_bki(vehicle, axle_combinationn[:-1], 0, ads)
                                right_constraint = get_constraint_bki_rt(vehicle, axle_combinationn[:-1], 0, ads)
                                bkonstraint = max(bkonstraint, right_constraint)
                        if bk == "bk4":
                            bkonstraint = get_constraint_bkiv(vehicle, axle_combinationn[:-1], 0, ads)
                        weight_sum = 0
                        for idx in axle_combinationn:
                            weight_sum += float(kn_to_t(acws[idx]))
                            # weight_sum += float(kn_to_t(acws[idx].text))
                        # print weight_sum, bkonstraint
                        if weight_sum > bkonstraint:
                            strg.append("towed vehicle constraint")
                            # print "lol"
                            broken = True
                            break
                if broken:
                    break

            # if strg != ts:
            # print strg

            # if bk != "bk4":
            om, modules_max_gvw = overloaded_modules(vehicle, conf, grps, bk, ads, acws)
            constraints.append(modules_max_gvw)
            # print om
            if len(om) > 0:
                # ovr = True
                strg.append("at least one module over constraint")

        # fd = open("gvw_overs.csv", "a")
        # fd.write(strg+"\n")
        # fd.close()
        return strg, constraints
    except:
        # print str(ex)
        return strg, constraints

def overloaded_modules(vehicle, conf, grps, bk, ads, acws):
    module_constraints = {"H2": 18, "H3": 28, "H4": 32, "H5": 40, "C2": 18, "C3": 25, "C4": 31, "V2": 5, "B3": 28,
                          "B2": 19.5, "A2": 18, "T1": 10, "T2": 20, "T3": 30, "T4": 38, "T5": 38, "T6": 38, "S1": 10,
                          "S2": 20, "S3": 30, "S4": 38, "S5": 38, "S6": 38, "D1": 10, "D2": 20, "D3": 30}

    ov_mod = list()
    try:
        cls = vehicle.find("wim").find("cls").text
        conf_scls = "subclass_" + cls
        ax_config = conf.get(conf_scls, "axle_configuration")
        modules = re.findall('..', ax_config)
        # weights = vehicle.find("wim").find("acws").findall("w")
        # distances = vehicle.find("wim").find("ads").findall("d")
        distances_ids = list()

        for i in range(len(ads)):
            distances_ids.append(i)

        cnt = 0
        modules_max_gvw = 0

        grps_dismembered = list()
        for grp in grps:
            for i in range(grp[1]):
                grps_dismembered.append(float(grp[3]) / float(grp[1]))

        start = 0

        # was_dolly = False
        dolly_ax_cnt = 0
        car_weight = -1

        for module in modules:
            module_ax_cnt = int(module[1:len(module)])
            tmp_cnt = cnt
            weight_sum = 0
            module_constraint = 0

            bk_constraint = 1000000
            # bk1_rt_constraint = 1000000

            if bk == "bk1":
                bk_constraint = get_constraint_bki(vehicle, distances_ids[start:start + module_ax_cnt - 1], 0, ads)
                if module[0].lower() == "t":
                    bk1_rt_constraint = get_constraint_bki_rt(vehicle, distances_ids[start:start + module_ax_cnt - 1],
                                                              0, ads)
                    if bk1_rt_constraint != -1:
                        bk_constraint = bk1_rt_constraint
                elif module[0].lower() == "s":
                    bk1_rt_constraint = get_constraint_bki_rt(vehicle, distances_ids[
                                                                       start - dolly_ax_cnt:start + module_ax_cnt - 1],
                                                              0, ads)
                    if bk1_rt_constraint != -1:
                        bk_constraint = bk1_rt_constraint
            else:
                bk_constraint = get_constraint_bkiv(vehicle, distances_ids[start:start + module_ax_cnt - 1], 0, ads)
            start += module_ax_cnt
            # print bk_constraint

            if module[0].lower() == "d":
                # was_dolly = True
                dolly_ax_cnt = module_ax_cnt
            else:
                # was_dolly = False
                dolly_ax_cnt = 0

            for i in range(cnt, cnt + module_ax_cnt):
                tmp_cnt += 1
                weight = float(kn_to_t(acws[i]))
                # weight = float(kn_to_t(acws[i].text))
                module_constraint += grps_dismembered[i]
                weight_sum += weight

            # car_exception = 1000000
            # if car_weight > -1:
            #  if module[0].lower() == "t" or module[0].lower() == "d":
            #    car_exception = min(car_weight, 3.5)

            # if module[0].lower() == "c":
            #  car_weight = weight_sum

            # print (module_constraint, module_constraints[module], bk_constraint)

            module_constraint1 = min(module_constraint, module_constraints[module], bk_constraint)
            if bk == "bk4":
                module_constraint1 = min(bk_constraint, module_constraint)
            cnt = tmp_cnt

            try:
                modules_max_gvw += module_constraint1
                if module_constraint1 < weight_sum:
                    ov_mod.append(module)
            except Exception as ex:
                # print str(ex)
                pass
                # return False
    except Exception as ex:
        # print str(ex)
        pass
        # return False

    return ov_mod, round(modules_max_gvw, 2)

## NEW
def TE_group(ads, group_max_distance):
    """Returns axle groups based on new group_max_distance --> SWE GROUPS"""

    result = ()
    size = 1
    for a in ads:
        if a > group_max_distance:
            result += (size,)
            size = 1
        else:
            size += 1
    result += (size,)
    return result
