import time

import psutil
from py_logging.cestel_logging import init_logger


class Module():
    def __init__(self, args, expected_params):
        self.end = False
        self.alive = True
        self.downstream_modules_dict = dict()
        self.sname = ""
        self.sites_path = ""
        # various bits of upstream information
        self.upstream_info = {}
        # force this here so logger will initialize
        self.name = args["name"]
        # each module gets it's own logger
        self.logger = init_logger(self.name)
        for key in expected_params.keys():
            if expected_params[key] != None:
                try:
                    setattr(self, key, args[key])
                except:
                    setattr(self, key, expected_params[key])
            else:
                try:
                    setattr(self, key, args[key])
                except:
                    self.logger.exception('Insufficient arguments:')
                    return

    def set_sites_path(self, sites_path):
        self.sites_path = sites_path

    def set_end(self):
        self.end = True

    # methods that "return True" are somwhat special and should be reimplemented in certain modules
    def add_downstream_module(self, module):
        self.downstream_modules_dict[module.get_name()] = module

    def set_site_name(self, sname):
        self.sname = sname

    def set_upstream_info(self, module_name, info_type, info_value):
        self.upstream_info[(module_name, info_type)] = info_value  # When sending data the fact that this is a tuple is fixed in the "ugly hack" part of status module.

    def get_name(self):
        return self.name

    def set_swd_version(self, version):
        return True

    # TODO: generalize this into "add_data" or something; this is a method for forwarding data to downstream modules
    def add_vehicle(self, sub_vehicle, module_name):
        return True

    def tell_offset(self, module_name, offsets_dict):
        return True

        # TODO: alarm module specific; does this need to be here?

    def register_alarm(self, module_name, module_type):
        return True

    # for now, only used in output module; this is used to prevent modules to send data to output modules if there is no listeners
    def is_doing_something(self):
        return True

    def is_alive(self):
        return self.alive

    def zzzzz(self, seconds):
        cnt = 0
        while cnt < seconds * 2:
            if self.end:
                self.alive = False
                return
            try:
                time.sleep(0.5)
            except:
                continue
            cnt += 1
        return

    def run(self):
        return True

    # This way of rounding introduces an inconsistency between Python2 and Python3, where Python2 may return 1 MB less, due to "round" function essentially being "floor".
    def get_total_mb(self, partition):
        return int(round(psutil.disk_usage(partition).total / 1024 / 1024))

    def get_free_mb(self, partition):
        return int(round(psutil.disk_usage(partition).free / 1024 / 1024))
