import datetime
import os
import socket
import subprocess
import time
from sys import platform

import serial

from generic_module import Module


class CtuModule(Module):
    def __init__(self, args):
        expected_params = {"udp_ip": "127.0.0.1", "udp_port": 9000, "serial_port": None, "baud": 115200, "interval": 30, "vpn_host": "172.16.0.1", "vpn_port": 80, "root_path": None, "relevant_for_listeners": "tu"}
        Module.__init__(self, args, expected_params)
        self.tdesc = ["ts", "T1__C", "T2__C", "T3__C", "T4__C", "Ti__C"]
        self.vdesc = ["ts", "Ub__V"]

    def generate_path(self, mod):
        pth = self.sites_path
        pth = pth + "/" + self.sname + "/ext"
        if not os.path.exists(pth):
            os.mkdir(pth)
        pth = pth + "/" + mod
        if not os.path.exists(pth):
            os.mkdir(pth)
        pth = pth + "/ctu"
        if not os.path.exists(pth):
            os.mkdir(pth)
        pth = pth + "/" + self.name
        if not os.path.exists(pth):
            os.mkdir(pth)
        return pth

    def ctucmd(self, ser, cmnd, resp='', to=0.5):
        if ser.timeout != to:
            ser.timeout = to
        ser.flushInput()
        ser.write((cmnd + '\n').encode())
        r = []
        while True:
            l = ser.readline().rstrip();
            if l == '':  # EOF
                return r
            r.append(l)
            if len(resp) > 0 and l.find(resp) != -1:  # resp found
                return r
            if len(r) > 10:  # safeguard
                return r

    def dict2confstr(self, section, d):
        r = '[' + section + ']' + '\n'
        for k, v in d.items():
            r += k + '=' + v + '\n'
        return r

    def run(self):
        self.alive = True
        self.end = False
        even_odd_flag = 1
        try:
            ser = serial.Serial(self.serial_port, self.baud)
            try:
                while True:
                    if self.end:
                        ser.close()
                        self.alive = False
                        self.logger.debug('Thread closed correctly.')
                        return
                    # a temporary hack!
                    if even_odd_flag == 0:
                        even_odd_flag = 1
                    else:
                        even_odd_flag = 0
                    # sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
                    # result = sock.connect_ex((self.vpn_host, self.vpn_port))
                    # try:
                    # sock.close()
                    # except Exception:
                    # pass
                    if platform == "win32":
                        ping = subprocess.Popen(["ping", "-n", "1", "-w", "2", self.vpn_host], stdout=subprocess.PIPE).communicate()[0]
                    else:
                        ping = subprocess.Popen(["ping", "-c", "1", "-w", "2", self.vpn_host], stdout=subprocess.PIPE).communicate()[0]
                    if ('unreachable' not in str(ping)) and ('timed' not in str(ping)) and ('failure' not in str(ping)):
                        self.ctucmd(ser, 'vPNON')
                    d = {}
                    d['dev'] = 'CTU-03';
                    d['ts'] = time.strftime('%Y-%m-%d-%H-%M-%S')
                    r = self.ctucmd(ser, 'FWVER')
                    if len(r) == 1:
                        j = r[0].find('firmware ver')
                        if j != -1:
                            d['fw'] = r[0][j + 12:].rstrip()
                    r = self.ctucmd(ser, 'SENS')
                    for i in range(len(r)):
                        s = r[i].split(b'=')
                        if len(s) == 2:
                            j = -1
                            u = '__?'
                            if s[0].startswith('U') and "u" in self.relevant_for_listeners.lower():
                                j = s[1].find('V')
                                u = '__V'
                            if s[0].startswith('T') and "t" in self.relevant_for_listeners.lower():
                                j = s[1].find('C')
                                u = '__C'
                            if j != -1:
                                d[s[0] + u] = s[1][:j]
                    for key, mod in self.downstream_modules_dict.items():
                        try:
                            mod.set_upstream_info(self.get_name(), "ctu_firmware_version", d['fw'])
                            # mod.set_ctu_fw(d['fw'])
                        except:
                            pass
                        try:
                            mod.set_upstream_info(self.get_name(), "siwim_system_voltage", d['Ub__V'])
                            # mod.set_voltage(d['Ub__V'])
                        except:
                            pass

                    if "t" in self.relevant_for_listeners.lower():
                        # maybe create method
                        pth = self.generate_path("temperature")
                        for key, mod in self.downstream_modules_dict.items():
                            mod.set_upstream_info(self.get_name(), "temperature_path", pth)
                        date = datetime.datetime.now().strftime('%Y-%m-%d')
                        fd = open(pth + "/" + date + ".csv", "a+")
                        header = "\t".join(self.tdesc)
                        # header = "ts" + "\t" + header
                        if not os.path.exists(pth + "/" + date + ".csv") or os.path.getsize(pth + "/" + date + ".csv") == 0:
                            fd.write(header + "\n")
                        tm = datetime.datetime.now().strftime('%Y-%m-%d-%H-%M-%S')
                        to_write = tm
                        for el in self.tdesc[1:]:
                            try:
                                to_write = to_write + "\t" + d[el]
                            except:
                                to_write = to_write + "\t" + "-273"
                        fd.write(to_write + "\n")
                        fd.close()
                        # -------------------

                    if "u" in self.relevant_for_listeners.lower():
                        # maybe create method
                        pth = self.generate_path("voltage")
                        for key, mod in self.downstream_modules_dict.items():
                            mod.set_upstream_info(self.get_name(), "voltage_path", pth)
                        date = datetime.datetime.now().strftime('%Y-%m-%d')
                        fd = open(pth + "/" + date + ".csv", "a+")
                        header = "\t".join(self.vdesc)
                        # header = "ts" + "\t" + header
                        if not os.path.exists(pth + "/" + date + ".csv") or os.path.getsize(pth + "/" + date + ".csv") == 0:
                            fd.write(header + "\n")
                        tm = datetime.datetime.now().strftime('%Y-%m-%d-%H-%M-%S')
                        to_write = tm + "\t"
                        for el in self.vdesc[1:]:
                            try:
                                to_write = to_write + "\t" + d[el]
                            except:
                                to_write = to_write + "\t" + "-273"
                        fd.write(to_write + "\n")
                        fd.close()
                        # -------------------

                    msg = self.dict2confstr('mydevice', d)  # json.dumps(d)
                    self.logger.debug(msg)
                    sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
                    try:
                        sock.sendto(msg.encode('utf-8'), (self.udp_ip, self.udp_port))
                    finally:
                        sock.close()
                    self.zzzzz(self.interval)
            finally:
                ser.close()
        except serial.SerialException as e:
            self.logger.error('SerialException: {}'.format(str(e)))
            self.zzzzz(2)
        except:
            self.logger.exception('Fatal error:')
            self.alive = False
