import base64

from acquisition.camera import CameraModule
from consts import CAM_LANES, CAM_PIC_TYPE, MOD_TYPE, RCV_OFFSET
from exceptions import NoPhoto, StopModule


class CameraArh(CameraModule):
    def __init__(self, args):
        # Initialize the module, passing it a list of keys that must exist for it to work properly
        CameraModule.__init__(self, args=args, mandatory_keys=(CAM_LANES, CAM_PIC_TYPE, MOD_TYPE, RCV_OFFSET))
        self.host = None  # Arh cameras don't use host key, but it is mandatory for correct functioning of CameraModule.

    def get_photo(self, veh) -> None:
        try:
            veh_ts, _, lane = self.get_photo_data(veh)
        except NoPhoto as e:
            self.logger.warning(e)
            return

        anpr_vehs = veh.findall('anpr')
        if len(anpr_vehs) == 0:
            raise NoPhoto('No anpr tag in vehicle.')
        anpr_veh = anpr_vehs[0]
        if self.picture_type == 'anpr':
            img_content = anpr_veh.find('lprimage').text
            photo_dir = 'lpr'
            self.generate_data_dir(photo_dir, veh_ts)
            image_blob = base64.b64decode(img_content)
            with open(f'{self.data_dirs[photo_dir]}/{veh_ts}_{lane}_p00.jpg', 'wb') as img:
                img.write(image_blob)

    def run(self) -> None:
        self.alive = True
        self.end = False

        try:
            self.main()
        except StopModule as e:
            self.log_stop_module(e)
        except:
            self.logger.exception('Fatal error:')
            self.alive = False
