import time


class RestartI(Exception):
    """ Exception that should be thrown when communication module triggers a reset. """
    pass


class ShutdownI(Exception):
    """ Exception that should be thrown when I is to shut down. """
    pass


class StopModule(Exception):
    """ Exception that should be thrown when a module is to be stopped. """

    def __init__(self, msg: str = 'Module stopping.', conn=None) -> None:
        """ Try to cleanly handle stopping of a module tread.
        :param msg: Message sent to exception handler.
        :param conn: Reference to the connection that should be closed.
        """
        super().__init__(msg)
        if conn:
            try:
                conn.shutdown()
            except:
                pass
            try:
                conn.close()
            except:
                pass


class NoPhoto(Exception):
    """ Exception that should be thrown when obtaining of a photo failed. """

    def __init__(self, msg='Sleeping for 0.5 second due to exception'):
        time.sleep(0.5)
        super().__init__(msg)


class NoData(Exception):
    """ Exception that should be thrown when getting data has failed. """

    def __init__(self, msg='Sleeping for 0.5 second due to exception'):
        time.sleep(0.5)
        super().__init__(msg)
