from datetime import datetime

from cestel_helpers.siwim import Siwim
import socket

size_length = 10
device_str = 'SI-060'
device_type = 1
camera_id = 1
zone_id = 1
request_type = 7

s = Siwim()
ts = s.ts_datetime_to_siwim(datetime.now())

data1 = (b'{"DetectionRequest":1,"DeviceStr":"' + device_str.encode() + b'","DeviceType":' + str(device_type).encode() + b',"CameraId":' + str(camera_id).encode() + b',"EventId":1,"ZoneId":'
         + str(zone_id).encode() + b',"MaxObjPerZone":1,"Timestamp":"' + ts.encode() + b'","MsgSize":"')
data2 = b'","RequestType":' + str(request_type).encode() + b',"ImageSrc":3,"ImageType":1}'
msg_size = len(data1) + len(data2) + size_length
final_msg = data1 + str(msg_size).encode().zfill(size_length) + data2

s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
s.connect(('172.16.15.29', 8099))
s.settimeout(10)
s.sendall(final_msg)

print(s.recv(1024))