# This file will contain all constants that are be used by the application.
import platform
from pathlib import Path

# Defaults required for starting the application (passing them as parameters will overwrite these values).
DEF_SIWIM_ROOT = Path('D:/siwim_mkiii') if platform.system() == 'Windows' else Path(Path.home(), 'siwim')
DEF_SITES_DIR = Path('sites')
DEF_SIWIM_E_CONF = Path('siwim_e/conf/siwim.conf')

# Logging
LOG_LEVEL = 'log_level'
LOG_LEVEL_CON = 'log_level_console'
LOG_ROTATING = 'rotating_log'
LOG_DIR = 'i_log'
LOG_LEVEL_DUMP = 'log_level_dump'
LOG_LEVEL_TIMER = 'log_level_timer'
LOG_FMT_FILE = 'file_format'
LOG_FMT_CON = 'console_format'
LOG_FMT_DUMP = '%(asctime)s [%(filename)s: %(lineno)d] %(message)s'
LOG_FMT_TIMER = '%(asctime)s %(message)s'
LOG_FMT_CORE_FILE = 'core_file_format'
LOG_FMT_CORE_CON = 'core_console_format'
LOG_NO_DATE = 'no_date'

# Modules
MOD_AGGR = 'aggregation'
MOD_CAM = 'camera'
MOD_CAN = 'can'
MOD_COMM = 'communication'
MOD_EFOY = 'efoy'
MOD_GAP = 'gap'
MOD_HYST = 'hysteresis'
MOD_MATCH = 'match'
MOD_OUT = 'output'
MOD_PAP = 'papago'
MOD_PIC = 'picture'
MOD_REC = 'acquisition'
MOD_STAT = 'status'
MOD_OCLI = 'output_client'
MOD_EVENTS = 'siwim_events'
MOD_THIES = 'thies'

# Constants
MOD_NAME = 'name'
SITE_NAME = 'siwim_site_name'
SIWIM_E_VERSION = 'siwim_e_version'
VER_FILE = '.version'
HASH_FILE = '.hashes'
LOGGER_MAIN = ''
MAIN_LOG_FILE = 'siwim_i'
TS_FORMAT_STRING = '%Y-%m-%d-%H-%M-%S-%f'
ROOT_OUTPUT = 'save_to_ext'

# Confs
CONF_GLOBAL = 'global.toml'
CONF_DOWNSTREAM = 'downstream.toml'
CONF_DIR = 'i_conf'
CONF_BACKUP_DIR = 'usr/backup/i_conf'

# Global
GLOBAL_SYSTEM_ID = 'system_id'
GLOBAL_NAME = 'name'
GLOBAL_AUTO_UPDATE = 'auto_update'
GLOBAL_UPDATE_CHANNEL = 'update_channel'
GLOBAL_ALLOW_ROLLBACK = 'allow_rollback'

# Saving
SAVE_PATH = 'path'
SAVE_HEADER = 'header'
SAVE_FOOTER = 'footer'
SAVE_SEPARATOR = 'separator'
SAVE_SUFFIX = 'suffix'
SAVE_CLEAR_WHITESPACE = 'remove_whitespace'

# Photo metadata
META_CAMERA_MAKE = 'camera_make'
META_CAMERA_MODEL = 'camera_model'
# Photo metadata from XML.
META_CONF = 'conf_id'
META_MEASUREMENT = 'measurement_id'
META_SPEED = 'v'
META_TIMESTAMP = 'ts'
META_VEHICLE = 'vehicle_id'
META_MAP = {
    META_CONF: 'Xmp.Site.ConfId',
    META_MEASUREMENT: 'Xmp.Site.MeasurementId',
    META_SPEED: 'Xmp.Vehicle.Speed',
    META_TIMESTAMP: 'Xmp.Vehicle.Timestamp',
    META_VEHICLE: 'Xmp.Vehicle.Id',
}

# Module
MOD_TYPE = 'type'

# Aggregation
AGGR_TIMEOUT = 'matching_timeout'
AGGR_FUZZINESS = 'fuzziness'

# Camera
CAM_TYPE = 'type'
CAM_HOST = 'host'
CAM_PORT = 'port'
CAM_FOCUS = 'offset'
CAM_LANES = 'lanes'
CAM_STORY = 'story'
CAM_STORY_BEFORE = 'story_before'
CAM_STORY_AFTER = 'story_after'
CAM_SAMPLING_INTERVAL = 'sampling_interval'
CAM_EVENTS = 'num_events_to_parse'
CAM_MAX_DIFF = 'max_time_diff'
CAM_MAX_TIME = 'max_wait_time'
CAM_USER = 'uname'
CAM_PASS = 'passw'
CAM_PIC_TYPE = 'picture_type'

# Can
CAN_RX_IP = 'udp_rx_ip'
CAN_RX_PORT = 'udp_rx_port'
CAN_TX_IP = 'udp_tx_ip'
CAN_TX_PORT = 'udp_tx_port'
CAN_E_IP = 'udp_e_ip'
CAN_E_PORT = 'udp_e_port'
CAN_SAVE_INTERVAL = 'interval'
CAN_LISTENERS = 'relevant_for_listeners'
CAN_FWVER = 'ap_fwver'
CAN_BOARD_IDS = 'board_ids'
CAN_UPTIME = 'ap_uptime'
CAN_INTERVAL = 'interval'
CAN_MK_IP = 'mk_ip'
CAN_MK_PORT = 'mk_port'

# Communication
COMM_PORT = 'port'
COMM_BACKLOG = 'backlog'
COMM_BUFFER = 'buffer'

# Efoy
EFOY_HOST = 'host'
EFOY_PORT = 'port'
EFOY_INTERVAL = 'interval'
EFOY_BUFFER = 'buffer'
EFOY_SAVE = 'save_to_disk'

# Gap
GAP_REMOVE = 'remove_duplicates'
GAP_TIME = 'time_gap'

# Hysteresis
HIST_IP = 'udp_ip'
HIST_PORT = 'udp_port'
HIST_SERIAL = 'serial_port'
HIST_BAUD = 'baud'
HIST_INTERVAL = 'interval'
HIST_LISTENERS = 'relevant_for_listeners'
HIST_VPN = 'vpn_host'
HIST_VPN_TIMEOUT = 'vpn_ping_num'

# Match
MATCH_FUZZINESS = 'fuzziness'
MATCH_LOOKBACK = 'lookback_days'
MATCH_MODULE = 'module'
MATCH_GRACE = 'grace_period'
MATCH_OFFSET = 'fixed_offset'
MATCH_MIN_COUNT = 'min_match'

# Output
OUT_PORT = 'port'
OUT_BACKLOG = 'backlog'
OUT_MAX_THREADS = 'max_clients'
OUT_FILTER_RULES = 'filter_rules'
OUT_HEARTBEAT = 'heartbeat_interval'
OUT_SAVE = 'save_data'

# Output client
OCLI_PORT = 'port'
OCLI_HOST = 'host'
OCLI_FILTER_RULES = 'filter_rules'
OCLI_SAVE = 'save_data'
OCLI_IDLE = 'max_idle_interval'

# Papago
PAPAGO_IP = 'udp_ip'
PAPAGO_PORT = 'udp_port'
PAPAGO_INTERVAL = 'interval'
PAPAGO_DEVICE_IP = 'device_ip'
PAPAGO_START = 'indexing_start'
PAPAGO_LISTENERS = 'relevant_for_listeners'

# Picture
PIC_PORT = 'port'
PIC_BACKLOG = 'backlog'
PIC_CAM_TYPES = 'default_cam_types'
PIC_CAM_NAMES = 'default_cam_names'
PIC_THREADS = 'max_clients'

# Postprocessing
POST_FUZZINESS = 'fuzziness'
POST_GRACE = 'grace_period'
POST_LOOKBACK = 'lookback_days'
POST_SWD_PATH = 'swd_dir'

# Receive
RCV_TYPE = 'type'
RCV_HOST = 'host'
RCV_PORT = 'port'
RCV_BUFFER = 'buffer'
RCV_SAVE = 'save_original'
RCV_LANES = 'lanes'
RCV_OFFSET = 'offset'
FFGROUP_VEH_END = 'vehicle_end'
RCV_USER = 'uname'
RCV_PASS = 'passw'

# Tecdetect4
TEC4_CAMERA_ID = 'camera_id'
TEC4_ZONE_ID = 'zone_id'
TEC4_REQUEST_TYPE = 'request_type'
TEC4_DEVICE_TYPE = 'camera'
TEC4_DEVICE_STR = 'device_str'

# Status
STAT_INTERVAL = 'interval'
STAT_HOST = 'host'
STAT_URL = 'url'
STAT_PROTOCOL = 'protocol'
STAT_CONF = 'ntp_conf_path'
STAT_OVPN = 'ovpn_path'
STAT_NTP = 'ntp_conf_path'
STAT_SAVE = 'save_curr_to_disk'

# Thies
THIES_INTERVAL = 'interval'
THIES_PORT = 'port'
