import base64
from collections import deque

from abstract.module import Module
from consts import CAM_LANES, CAM_PIC_TYPE, MOD_TYPE, RCV_OFFSET
from exceptions import NoPhoto, StopModule


class CameraArh(Module):
    def __init__(self, args):
        self.vehicles_dict = {}
        # Define defaults that should be overwritten by the conf.
        self.lanes = []
        self.missed_count = 0
        self.uname = ''
        self.passw = ''
        self.max_wait_time = 0

        # Initialize the module, passing it a list of keys that must exist for it to work properly
        Module.__init__(self, args, mandatory_keys=(CAM_LANES, CAM_PIC_TYPE, MOD_TYPE, RCV_OFFSET))
        self.type = 'arh'
        self.vehicles_dict = {}
        self.host = None  # FIXME Arh cameras don't use host key, but it is mandatory for correct functioning ... or it was.

    def get_photo(self, veh) -> None:
        try:
            veh_ts, _, lane = self.get_photo_data(veh, self.max_wait_time)
        except NoPhoto as e:
            self.logger.warning(e)
            return

        anpr_vehs = veh.findall('anpr')
        if len(anpr_vehs) == 0:
            raise NoPhoto('No anpr tag in vehicle.')
        anpr_veh = anpr_vehs[0]
        if self.picture_type == 'anpr':
            img_content = anpr_veh.find('lprimage').text
            photo_dir = 'lpr'
            self.generate_data_dir(photo_dir, veh_ts)
            image_blob = base64.b64decode(img_content)
            with open(f'{self.data_dirs[photo_dir]}/{veh_ts}_{lane}_p00.jpg', 'wb') as img:
                img.write(image_blob)

    def add_vehicle(self, vehicle, recv_module_name):
        if recv_module_name not in self.vehicles_dict:
            self.vehicles_dict[recv_module_name] = deque()
        self.vehicles_dict[recv_module_name].append(vehicle)

    def run(self) -> None:
        self.alive = True
        self.end = False

        try:
            self.camera_loop()
        except StopModule as e:
            self.log_stop_module(e)
        except:
            self.logger.exception('Fatal error:')
            self.alive = False
